/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.ui.resource;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import java.beans.ConstructorProperties;
import java.net.URI;
import java.util.LinkedHashMap;
import java.util.Map;
import net.nemerosa.ontrack.ui.resource.Link;

public abstract class LinkContainer<L extends LinkContainer<L>> {
    private final URI _self;
    private final Map<String, URI> links = new LinkedHashMap<String, URI>();

    public L with(String name, URI uri, boolean authorized) {
        if (authorized) {
            return this.with(name, uri);
        }
        return (L)this;
    }

    private L with(Link link) {
        return this.with(link.getName(), link.getHref());
    }

    public L with(String name, URI uri) {
        this.links.put(name, uri);
        return (L)this;
    }

    @JsonAnyGetter
    public Map<String, URI> getLinks() {
        return this.links;
    }

    @ConstructorProperties(value={"_self"})
    public LinkContainer(URI _self) {
        this._self = _self;
    }

    public URI get_self() {
        return this._self;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LinkContainer)) {
            return false;
        }
        LinkContainer other = (LinkContainer)o;
        if (!other.canEqual(this)) {
            return false;
        }
        URI this$_self = this.get_self();
        URI other$_self = other.get_self();
        if (this$_self == null ? other$_self != null : !((Object)this$_self).equals(other$_self)) {
            return false;
        }
        Map<String, URI> this$links = this.getLinks();
        Map<String, URI> other$links = other.getLinks();
        return !(this$links == null ? other$links != null : !((Object)this$links).equals(other$links));
    }

    protected boolean canEqual(Object other) {
        return other instanceof LinkContainer;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        URI $_self = this.get_self();
        result = result * 59 + ($_self == null ? 0 : ((Object)$_self).hashCode());
        Map<String, URI> $links = this.getLinks();
        result = result * 59 + ($links == null ? 0 : ((Object)$links).hashCode());
        return result;
    }

    public String toString() {
        return "LinkContainer(_self=" + this.get_self() + ", links=" + this.getLinks() + ")";
    }
}

