/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.graphql.support;

import graphql.Scalars;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLEnumType;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLType;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.nemerosa.ontrack.model.structure.Entity;
import net.nemerosa.ontrack.model.structure.ID;
import org.apache.commons.lang3.EnumUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.text.WordUtils;

public final class GraphqlUtils {
    public static final String ID = "id";
    public static final String NAME = "name";
    public static final String DISABLED = "disabled";
    public static final String DESCRIPTION = "description";
    public static final String STD_LIST_ARG_FIRST = "first";
    public static final String STD_LIST_ARG_LAST = "last";

    public static GraphQLFieldDefinition idField() {
        return GraphQLFieldDefinition.newFieldDefinition().name(ID).type((GraphQLOutputType)new GraphQLNonNull((GraphQLType)Scalars.GraphQLInt)).dataFetcher(environment -> {
            Object source = environment.getSource();
            if (source instanceof Entity) {
                ID id = ((Entity)source).getId();
                return id != null ? Integer.valueOf(id.get()) : null;
            }
            return null;
        }).build();
    }

    public static GraphQLFieldDefinition nameField() {
        return GraphqlUtils.nameField("");
    }

    public static GraphQLFieldDefinition nameField(String description) {
        return GraphQLFieldDefinition.newFieldDefinition().name(NAME).description(description).type((GraphQLOutputType)Scalars.GraphQLString).build();
    }

    public static GraphQLFieldDefinition stringField(String name, String description) {
        return GraphQLFieldDefinition.newFieldDefinition().name(name).description(description).type((GraphQLOutputType)Scalars.GraphQLString).build();
    }

    public static GraphQLFieldDefinition disabledField() {
        return GraphQLFieldDefinition.newFieldDefinition().name(DISABLED).type((GraphQLOutputType)new GraphQLNonNull((GraphQLType)Scalars.GraphQLBoolean)).build();
    }

    public static GraphQLFieldDefinition descriptionField() {
        return GraphQLFieldDefinition.newFieldDefinition().name(DESCRIPTION).type((GraphQLOutputType)Scalars.GraphQLString).build();
    }

    public static <E extends Enum<E>> GraphQLOutputType newEnumType(Class<E> enumClass) {
        GraphQLEnumType.Builder builder = GraphQLEnumType.newEnum().name(enumClass.getSimpleName());
        for (Enum e : EnumUtils.getEnumList(enumClass)) {
            builder = builder.value(e.name(), (Object)e);
        }
        return builder.build();
    }

    public static GraphQLOutputType stdList(GraphQLType type) {
        return new GraphQLNonNull((GraphQLType)new GraphQLList((GraphQLType)new GraphQLNonNull(type)));
    }

    public static OptionalInt getIntArgument(DataFetchingEnvironment environment, String name) {
        Object value = environment.getArgument(name);
        if (value instanceof Integer) {
            return OptionalInt.of((Integer)value);
        }
        return OptionalInt.empty();
    }

    public static boolean getBooleanArgument(DataFetchingEnvironment environment, String name, boolean defaultValue) {
        Object value = environment.getArgument(name);
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        return defaultValue;
    }

    public static Optional<String> getStringArgument(DataFetchingEnvironment environment, String name) {
        Object value = environment.getArgument(name);
        if (value instanceof String) {
            return Optional.of((String)value);
        }
        return Optional.empty();
    }

    public static void checkArgList(DataFetchingEnvironment environment, String ... args) {
        HashSet<String> expectedArgs;
        Set<String> actualArgs = GraphqlUtils.getActualArguments(environment).keySet();
        if (!Objects.equals(actualArgs, expectedArgs = new HashSet<String>(Arrays.asList(args)))) {
            throw new IllegalStateException(String.format("Expected this list of arguments: %s, but was: %s", expectedArgs, actualArgs));
        }
    }

    private static Map<String, Object> getActualArguments(DataFetchingEnvironment environment) {
        return environment.getArguments().entrySet().stream().filter(entry -> entry.getValue() != null).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public static <T, R> DataFetcher<R> fetcher(Class<T> sourceType, Function<T, R> fn) {
        return environment -> {
            Object o = environment.getSource();
            if (sourceType.isInstance(o)) {
                Object t = o;
                return fn.apply(t);
            }
            return null;
        };
    }

    public static <T, R> DataFetcher<R> fetcher(Class<T> sourceType, BiFunction<DataFetchingEnvironment, T, R> fn) {
        return environment -> {
            Object o = environment.getSource();
            if (sourceType.isInstance(o)) {
                Object t = o;
                return fn.apply(environment, t);
            }
            return null;
        };
    }

    public static String lowerCamelCase(String text) {
        if (text == null) {
            return null;
        }
        if (StringUtils.isBlank((CharSequence)text)) {
            return "";
        }
        return StringUtils.uncapitalize((String)StringUtils.remove((String)WordUtils.capitalizeFully((String)StringUtils.replacePattern((String)text, (String)"[^A-Za-z0-9]", (String)" "), (char[])new char[]{' '}), (String)" "));
    }

    public static List<GraphQLArgument> stdListArguments() {
        return Arrays.asList(GraphQLArgument.newArgument().name(STD_LIST_ARG_FIRST).description("Number of items to return from the beginning of the list").type((GraphQLInputType)Scalars.GraphQLInt).build(), GraphQLArgument.newArgument().name(STD_LIST_ARG_LAST).description("Number of items to return from the end of the list").type((GraphQLInputType)Scalars.GraphQLInt).build());
    }

    public static <T> List<T> stdListArgumentsFilter(List<T> list, DataFetchingEnvironment environment) {
        OptionalInt first = GraphqlUtils.getIntArgument(environment, STD_LIST_ARG_FIRST);
        OptionalInt last = GraphqlUtils.getIntArgument(environment, STD_LIST_ARG_LAST);
        if (first.isPresent()) {
            if (last.isPresent()) {
                throw new IllegalStateException(String.format("Only one of `%s` or `%s` is expected as argument", STD_LIST_ARG_FIRST, STD_LIST_ARG_LAST));
            }
            return list.subList(0, Math.min(list.size(), first.getAsInt()));
        }
        if (last.isPresent()) {
            return list.subList(Math.max(0, list.size() - last.getAsInt()), list.size());
        }
        return list;
    }
}

