/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.graphql.support;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.collect.ImmutableSet;
import graphql.Scalars;
import graphql.schema.GraphQLInputObjectField;
import graphql.schema.GraphQLInputObjectType;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLScalarType;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kotlin.jvm.functions.Function0;
import net.nemerosa.ontrack.graphql.schema.GQLTypeCache;
import net.nemerosa.ontrack.graphql.support.GQLScalarJSON;
import net.nemerosa.ontrack.graphql.support.GQLScalarLocalDateTime;
import org.springframework.beans.BeanUtils;

public class GraphQLBeanConverter {
    private static final Set<String> DEFAULT_EXCLUSIONS = ImmutableSet.of((Object)"class");

    public static GraphQLInputType asInputType(Class<?> type) {
        GraphQLInputObjectType.Builder builder = GraphQLInputObjectType.newInputObject().name(type.getSimpleName());
        for (PropertyDescriptor descriptor : BeanUtils.getPropertyDescriptors(type)) {
            if (descriptor.getReadMethod() == null) continue;
            String name = descriptor.getName();
            String description = descriptor.getShortDescription();
            GraphQLScalarType scalarType = GraphQLBeanConverter.getScalarType(descriptor.getPropertyType());
            if (scalarType == null) continue;
            builder = builder.field(arg_0 -> GraphQLBeanConverter.lambda$asInputType$0(name, description, (GraphQLInputType)scalarType, arg_0));
        }
        return builder.build();
    }

    public static GraphQLObjectType asObjectType(Class<?> type, GQLTypeCache cache) {
        return GraphQLBeanConverter.asObjectType(type, cache, null);
    }

    public static GraphQLObjectType asObjectType(Class<?> type, GQLTypeCache cache, Set<String> exclusions) {
        GraphQLObjectType.Builder builder = GraphQLObjectType.newObject().name(type.getSimpleName());
        HashSet<String> actualExclusions = new HashSet<String>(DEFAULT_EXCLUSIONS);
        if (exclusions != null) {
            actualExclusions.addAll(exclusions);
        }
        for (PropertyDescriptor descriptor : BeanUtils.getPropertyDescriptors(type)) {
            String name;
            if (descriptor.getReadMethod() == null || actualExclusions.contains(name = descriptor.getName())) continue;
            String description = descriptor.getShortDescription();
            Class<?> propertyType = descriptor.getPropertyType();
            GraphQLScalarType scalarType = GraphQLBeanConverter.getScalarType(propertyType);
            if (scalarType != null) {
                builder = builder.field(field -> field.name(name).description(description).type((GraphQLOutputType)scalarType));
                continue;
            }
            if (Map.class.isAssignableFrom(propertyType) || Collection.class.isAssignableFrom(propertyType)) {
                throw new IllegalArgumentException(String.format("Maps and collections are not supported yet: %s in %s", name, type.getName()));
            }
            GraphQLObjectType propertyObjectType = cache.getOrCreate(propertyType.getSimpleName(), (Function0<? extends GraphQLObjectType>)((Function0)() -> GraphQLBeanConverter.asObjectType(propertyType, cache)));
            builder = builder.field(field -> field.name(name).description(description).type((GraphQLOutputType)propertyObjectType));
        }
        return builder.build();
    }

    public static GraphQLScalarType getScalarType(Class<?> type) {
        if (Integer.class.isAssignableFrom(type) || Integer.TYPE.isAssignableFrom(type)) {
            return Scalars.GraphQLInt;
        }
        if (Long.class.isAssignableFrom(type) || Long.TYPE.isAssignableFrom(type)) {
            return Scalars.GraphQLLong;
        }
        if (Double.class.isAssignableFrom(type) || Double.TYPE.isAssignableFrom(type)) {
            return Scalars.GraphQLFloat;
        }
        if (Float.class.isAssignableFrom(type) || Float.TYPE.isAssignableFrom(type)) {
            return Scalars.GraphQLFloat;
        }
        if (Boolean.class.isAssignableFrom(type) || Boolean.TYPE.isAssignableFrom(type)) {
            return Scalars.GraphQLBoolean;
        }
        if (String.class.isAssignableFrom(type)) {
            return Scalars.GraphQLString;
        }
        if (JsonNode.class.isAssignableFrom(type)) {
            return GQLScalarJSON.INSTANCE;
        }
        if (LocalDateTime.class.isAssignableFrom(type)) {
            return GQLScalarLocalDateTime.INSTANCE;
        }
        return null;
    }

    public static <T> T asObject(Object argument, Class<T> type) {
        if (argument == null) {
            return null;
        }
        if (argument instanceof Map) {
            Map map = (Map)argument;
            Object o = BeanUtils.instantiate(type);
            for (PropertyDescriptor descriptor : BeanUtils.getPropertyDescriptors(type)) {
                Object arg;
                Method writeMethod = descriptor.getWriteMethod();
                if (writeMethod == null || (arg = map.get(descriptor.getName())) == null) continue;
                try {
                    writeMethod.invoke(o, arg);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    throw new IllegalStateException("Cannot set property " + descriptor.getName());
                }
            }
            return (T)o;
        }
        throw new IllegalArgumentException("Argument is expected to be a map");
    }

    private static /* synthetic */ GraphQLInputObjectField.Builder lambda$asInputType$0(String name, String description, GraphQLInputType scalarType, GraphQLInputObjectField.Builder field) {
        return field.name(name).description(description).type(scalarType);
    }
}

