/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.graphql.schema;

import graphql.Scalars;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeReference;
import java.util.List;
import java.util.Optional;
import net.nemerosa.ontrack.graphql.schema.AbstractGQLProjectEntity;
import net.nemerosa.ontrack.graphql.schema.GQLProjectEntityFieldContributor;
import net.nemerosa.ontrack.graphql.schema.GQLProjectEntityInterface;
import net.nemerosa.ontrack.graphql.schema.GQLTypeCache;
import net.nemerosa.ontrack.graphql.schema.GQLTypeCreation;
import net.nemerosa.ontrack.graphql.schema.GQLTypeValidationRunStatus;
import net.nemerosa.ontrack.graphql.schema.GQLTypeValidationStamp;
import net.nemerosa.ontrack.graphql.support.GraphqlUtils;
import net.nemerosa.ontrack.model.structure.ProjectEntityType;
import net.nemerosa.ontrack.model.structure.Signature;
import net.nemerosa.ontrack.model.structure.ValidationRun;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class GQLTypeValidationRun
extends AbstractGQLProjectEntity<ValidationRun> {
    public static final String VALIDATION_RUN = "ValidationRun";
    private final GQLTypeValidationRunStatus validationRunStatus;
    private final GQLProjectEntityInterface projectEntityInterface;

    @Autowired
    public GQLTypeValidationRun(GQLTypeCreation creation, GQLTypeValidationRunStatus validationRunStatus, List<GQLProjectEntityFieldContributor> projectEntityFieldContributors, GQLProjectEntityInterface projectEntityInterface) {
        super(ValidationRun.class, ProjectEntityType.VALIDATION_RUN, projectEntityFieldContributors, creation);
        this.validationRunStatus = validationRunStatus;
        this.projectEntityInterface = projectEntityInterface;
    }

    @Override
    public String getTypeName() {
        return VALIDATION_RUN;
    }

    @Override
    public GraphQLObjectType createType(GQLTypeCache cache) {
        return GraphQLObjectType.newObject().name(VALIDATION_RUN).withInterface(this.projectEntityInterface.getTypeRef()).fields(this.projectEntityInterfaceFields()).field(GraphQLFieldDefinition.newFieldDefinition().name("build").description("Associated build").type((GraphQLOutputType)new GraphQLNonNull((GraphQLType)new GraphQLTypeReference("Build"))).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("validationStamp").description("Associated validation stamp").type((GraphQLOutputType)new GraphQLNonNull((GraphQLType)new GraphQLTypeReference(GQLTypeValidationStamp.Companion.getVALIDATION_STAMP()))).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("runOrder").description("Run order").type((GraphQLOutputType)Scalars.GraphQLInt).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("validationRunStatuses").description("List of validation statuses").type(GraphqlUtils.stdList((GraphQLType)this.validationRunStatus.getTypeRef())).build()).build();
    }

    @Override
    protected Optional<Signature> getSignature(ValidationRun entity) {
        return Optional.ofNullable(entity.getLastStatus().getSignature());
    }
}

