/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.graphql.schema;

import graphql.Scalars;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import net.nemerosa.ontrack.graphql.schema.GQLType;
import net.nemerosa.ontrack.graphql.schema.GQLTypeCache;
import net.nemerosa.ontrack.graphql.schema.GQLTypePropertyType;
import net.nemerosa.ontrack.graphql.support.GQLScalarJSON;
import net.nemerosa.ontrack.graphql.support.GraphqlUtils;
import net.nemerosa.ontrack.json.JsonUtils;
import net.nemerosa.ontrack.model.structure.Property;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class GQLTypeProperty
implements GQLType {
    public static final String PROPERTY = "Property";
    private final GQLTypePropertyType propertyType;

    @Autowired
    public GQLTypeProperty(GQLTypePropertyType propertyType) {
        this.propertyType = propertyType;
    }

    @Override
    public String getTypeName() {
        return PROPERTY;
    }

    @Override
    public GraphQLObjectType createType(GQLTypeCache cache) {
        return GraphQLObjectType.newObject().name(PROPERTY).field(GraphQLFieldDefinition.newFieldDefinition().name("type").description("Property type").type((GraphQLOutputType)this.propertyType.getTypeRef()).dataFetcher(GraphqlUtils.fetcher(Property.class, Property::getTypeDescriptor)).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("value").description("JSON representation of the value").type((GraphQLOutputType)GQLScalarJSON.INSTANCE).dataFetcher(GraphqlUtils.fetcher(Property.class, this::getValue)).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("editable").description("True is the field is editable").type((GraphQLOutputType)Scalars.GraphQLBoolean).dataFetcher(GraphqlUtils.fetcher(Property.class, Property::isEditable)).build()).build();
    }

    private String getValue(Property<?> p) {
        Object value = p.getValue();
        return value == null ? null : JsonUtils.toJSONString((Object)value);
    }
}

