/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.graphql.schema;

import graphql.Scalars;
import graphql.schema.DataFetcher;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeReference;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.nemerosa.ontrack.graphql.schema.AbstractGQLProjectEntity;
import net.nemerosa.ontrack.graphql.schema.GQLProjectEntityFieldContributor;
import net.nemerosa.ontrack.graphql.schema.GQLProjectEntityInterface;
import net.nemerosa.ontrack.graphql.schema.GQLTypeCache;
import net.nemerosa.ontrack.graphql.schema.GQLTypeCreation;
import net.nemerosa.ontrack.graphql.schema.GQLTypePromotionRun;
import net.nemerosa.ontrack.graphql.support.GraphqlUtils;
import net.nemerosa.ontrack.model.structure.ProjectEntityType;
import net.nemerosa.ontrack.model.structure.PromotionLevel;
import net.nemerosa.ontrack.model.structure.Signature;
import net.nemerosa.ontrack.model.structure.StructureService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class GQLTypePromotionLevel
extends AbstractGQLProjectEntity<PromotionLevel> {
    public static final String PROMOTION_LEVEL = "PromotionLevel";
    private final StructureService structureService;
    private final GQLTypePromotionRun promotionRun;
    private final GQLProjectEntityInterface projectEntityInterface;

    @Autowired
    public GQLTypePromotionLevel(StructureService structureService, GQLTypeCreation creation, GQLTypePromotionRun promotionRun, List<GQLProjectEntityFieldContributor> projectEntityFieldContributors, GQLProjectEntityInterface projectEntityInterface) {
        super(PromotionLevel.class, ProjectEntityType.PROMOTION_LEVEL, projectEntityFieldContributors, creation);
        this.structureService = structureService;
        this.promotionRun = promotionRun;
        this.projectEntityInterface = projectEntityInterface;
    }

    @Override
    public String getTypeName() {
        return PROMOTION_LEVEL;
    }

    @Override
    public GraphQLObjectType createType(GQLTypeCache cache) {
        return GraphQLObjectType.newObject().name(PROMOTION_LEVEL).withInterface(this.projectEntityInterface.getTypeRef()).fields(this.projectEntityInterfaceFields()).field(f -> f.name("image").description("Flag to indicate if an image is associated").type((GraphQLOutputType)Scalars.GraphQLBoolean)).field(GraphQLFieldDefinition.newFieldDefinition().name("branch").description("Reference to branch").type((GraphQLOutputType)new GraphQLTypeReference("Branch")).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("promotionRuns").description("List of runs for this promotion").type(GraphqlUtils.stdList((GraphQLType)this.promotionRun.getTypeRef())).argument(GraphqlUtils.stdListArguments()).dataFetcher(this.promotionLevelPromotionRunsFetcher()).build()).build();
    }

    private DataFetcher promotionLevelPromotionRunsFetcher() {
        return environment -> {
            Object source = environment.getSource();
            if (source instanceof PromotionLevel) {
                PromotionLevel promotionLevel = (PromotionLevel)source;
                List promotionRuns = this.structureService.getPromotionRunsForPromotionLevel(promotionLevel.getId());
                return GraphqlUtils.stdListArgumentsFilter(promotionRuns, environment);
            }
            return Collections.emptyList();
        };
    }

    @Override
    protected Optional<Signature> getSignature(PromotionLevel entity) {
        return Optional.ofNullable(entity.getSignature());
    }
}

