/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.graphql.schema;

import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeReference;
import java.beans.ConstructorProperties;
import java.util.Collection;
import net.nemerosa.ontrack.graphql.schema.GQLType;
import net.nemerosa.ontrack.graphql.schema.GQLTypeCache;
import net.nemerosa.ontrack.graphql.support.GraphqlUtils;
import net.nemerosa.ontrack.model.security.Account;
import net.nemerosa.ontrack.model.security.AccountGroup;
import org.springframework.stereotype.Component;

@Component
public class GQLTypeProjectAuthorization
implements GQLType {
    public static final String PROJECT_AUTHORIZATION = "ProjectAuthorization";

    @Override
    public String getTypeName() {
        return PROJECT_AUTHORIZATION;
    }

    @Override
    public GraphQLObjectType createType(GQLTypeCache cache) {
        return GraphQLObjectType.newObject().name(PROJECT_AUTHORIZATION).field(GraphqlUtils.stringField("id", "ID of the role")).field(GraphqlUtils.nameField("Unique name for the role")).field(GraphqlUtils.stringField("description", "Description of the role")).field(f -> f.name("groups").description("List of groups having this role").type(GraphqlUtils.stdList((GraphQLType)new GraphQLTypeReference("AccountGroup")))).field(f -> f.name("accounts").description("List of accounts having this role").type(GraphqlUtils.stdList((GraphQLType)new GraphQLTypeReference("Account")))).build();
    }

    public static class Model {
        private final String id;
        private final String name;
        private final String description;
        private final Collection<AccountGroup> groups;
        private final Collection<Account> accounts;

        @ConstructorProperties(value={"id", "name", "description", "groups", "accounts"})
        public Model(String id, String name, String description, Collection<AccountGroup> groups, Collection<Account> accounts) {
            this.id = id;
            this.name = name;
            this.description = description;
            this.groups = groups;
            this.accounts = accounts;
        }

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        public Collection<AccountGroup> getGroups() {
            return this.groups;
        }

        public Collection<Account> getAccounts() {
            return this.accounts;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Model)) {
                return false;
            }
            Model other = (Model)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$id = this.getId();
            String other$id = other.getId();
            if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$description = this.getDescription();
            String other$description = other.getDescription();
            if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
                return false;
            }
            Collection<AccountGroup> this$groups = this.getGroups();
            Collection<AccountGroup> other$groups = other.getGroups();
            if (this$groups == null ? other$groups != null : !((Object)this$groups).equals(other$groups)) {
                return false;
            }
            Collection<Account> this$accounts = this.getAccounts();
            Collection<Account> other$accounts = other.getAccounts();
            return !(this$accounts == null ? other$accounts != null : !((Object)this$accounts).equals(other$accounts));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Model;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $id = this.getId();
            result = result * 59 + ($id == null ? 43 : $id.hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $description = this.getDescription();
            result = result * 59 + ($description == null ? 43 : $description.hashCode());
            Collection<AccountGroup> $groups = this.getGroups();
            result = result * 59 + ($groups == null ? 43 : ((Object)$groups).hashCode());
            Collection<Account> $accounts = this.getAccounts();
            result = result * 59 + ($accounts == null ? 43 : ((Object)$accounts).hashCode());
            return result;
        }

        public String toString() {
            return "GQLTypeProjectAuthorization.Model(id=" + this.getId() + ", name=" + this.getName() + ", description=" + this.getDescription() + ", groups=" + this.getGroups() + ", accounts=" + this.getAccounts() + ")";
        }
    }
}

