/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.graphql.schema;

import graphql.Scalars;
import graphql.schema.DataFetcher;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLType;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.nemerosa.ontrack.graphql.schema.AbstractGQLProjectEntity;
import net.nemerosa.ontrack.graphql.schema.GQLProjectEntityFieldContributor;
import net.nemerosa.ontrack.graphql.schema.GQLProjectEntityInterface;
import net.nemerosa.ontrack.graphql.schema.GQLTypeBranch;
import net.nemerosa.ontrack.graphql.schema.GQLTypeCache;
import net.nemerosa.ontrack.graphql.schema.GQLTypeCreation;
import net.nemerosa.ontrack.graphql.support.GraphqlUtils;
import net.nemerosa.ontrack.model.structure.Branch;
import net.nemerosa.ontrack.model.structure.Project;
import net.nemerosa.ontrack.model.structure.ProjectEntityType;
import net.nemerosa.ontrack.model.structure.Signature;
import net.nemerosa.ontrack.model.structure.StructureService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class GQLTypeProject
extends AbstractGQLProjectEntity<Project> {
    public static final String PROJECT = "Project";
    private final StructureService structureService;
    private final GQLProjectEntityInterface projectEntityInterface;
    private final GQLTypeBranch branch;

    @Autowired
    public GQLTypeProject(StructureService structureService, GQLTypeCreation creation, GQLTypeBranch branch, List<GQLProjectEntityFieldContributor> projectEntityFieldContributors, GQLProjectEntityInterface projectEntityInterface) {
        super(Project.class, ProjectEntityType.PROJECT, projectEntityFieldContributors, creation);
        this.structureService = structureService;
        this.branch = branch;
        this.projectEntityInterface = projectEntityInterface;
    }

    @Override
    public String getTypeName() {
        return PROJECT;
    }

    @Override
    public GraphQLObjectType createType(GQLTypeCache cache) {
        return GraphQLObjectType.newObject().name(PROJECT).withInterface(this.projectEntityInterface.getTypeRef()).fields(this.projectEntityInterfaceFields()).field(GraphqlUtils.disabledField()).field(GraphQLFieldDefinition.newFieldDefinition().name("branches").type(GraphqlUtils.stdList((GraphQLType)this.branch.getTypeRef())).argument(GraphQLArgument.newArgument().name("name").description("Regular expression to match against the branch name").type((GraphQLInputType)Scalars.GraphQLString).build()).dataFetcher(this.projectBranchesFetcher()).build()).build();
    }

    private DataFetcher projectBranchesFetcher() {
        return environment -> {
            Object source = environment.getSource();
            if (source instanceof Project) {
                Project project = (Project)source;
                String name = (String)environment.getArgument("name");
                Predicate<Branch> filter2 = b -> true;
                if (name != null) {
                    Pattern nameFilter = Pattern.compile(name);
                    filter2 = filter2.and(branch -> nameFilter.matcher(branch.getName()).matches());
                }
                return this.structureService.getBranchesForProject(project.getId()).stream().filter(filter2).collect(Collectors.toList());
            }
            return Collections.emptyList();
        };
    }

    @Override
    protected Optional<Signature> getSignature(Project entity) {
        return Optional.ofNullable(entity.getSignature());
    }
}

