/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.graphql.schema;

import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeReference;
import net.nemerosa.ontrack.graphql.schema.GQLType;
import net.nemerosa.ontrack.graphql.schema.GQLTypeCache;
import net.nemerosa.ontrack.graphql.support.GraphqlUtils;
import net.nemerosa.ontrack.model.security.AccountService;
import net.nemerosa.ontrack.model.security.GlobalRole;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class GQLTypeGlobalRole
implements GQLType {
    public static final String GLOBAL_ROLE = "GlobalRole";
    private final AccountService accountService;

    @Autowired
    public GQLTypeGlobalRole(AccountService accountService) {
        this.accountService = accountService;
    }

    @Override
    public String getTypeName() {
        return GLOBAL_ROLE;
    }

    @Override
    public GraphQLObjectType createType(GQLTypeCache cache) {
        return GraphQLObjectType.newObject().name(GLOBAL_ROLE).field(GraphqlUtils.stringField("id", "ID of the role")).field(GraphqlUtils.nameField("Unique name for the role")).field(GraphqlUtils.stringField("description", "Description of the role")).field(f -> f.name("groups").description("List of groups having this role").type(GraphqlUtils.stdList((GraphQLType)new GraphQLTypeReference("AccountGroup"))).dataFetcher(GraphqlUtils.fetcher(GlobalRole.class, arg_0 -> ((AccountService)this.accountService).findAccountGroupsByGlobalRole(arg_0)))).field(f -> f.name("accounts").description("List of accounts having this role").type(GraphqlUtils.stdList((GraphQLType)new GraphQLTypeReference("Account"))).dataFetcher(GraphqlUtils.fetcher(GlobalRole.class, arg_0 -> ((AccountService)this.accountService).findAccountsByGlobalRole(arg_0)))).build();
    }
}

