/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.graphql.schema;

import graphql.Scalars;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import net.nemerosa.ontrack.graphql.schema.GQLType;
import net.nemerosa.ontrack.graphql.schema.GQLTypeCache;
import net.nemerosa.ontrack.graphql.schema.GQLTypeExtensionFeatureDescription;
import net.nemerosa.ontrack.graphql.support.GQLScalarJSON;
import net.nemerosa.ontrack.graphql.support.GraphqlUtils;
import net.nemerosa.ontrack.json.JsonUtils;
import net.nemerosa.ontrack.model.structure.Decoration;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class GQLTypeDecoration
implements GQLType {
    public static final String DECORATION = "Decoration";
    private final GQLTypeExtensionFeatureDescription extensionFeatureDescription;

    @Autowired
    public GQLTypeDecoration(GQLTypeExtensionFeatureDescription extensionFeatureDescription) {
        this.extensionFeatureDescription = extensionFeatureDescription;
    }

    @Override
    public String getTypeName() {
        return DECORATION;
    }

    @Override
    public GraphQLObjectType createType(GQLTypeCache cache) {
        return GraphQLObjectType.newObject().name(DECORATION).field(GraphQLFieldDefinition.newFieldDefinition().name("decorationType").description("Decoration type").type((GraphQLOutputType)Scalars.GraphQLString).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("data").description("JSON representation of the decoration data").type((GraphQLOutputType)GQLScalarJSON.INSTANCE).dataFetcher(GraphqlUtils.fetcher(Decoration.class, this::getData)).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("error").description("Any error message associated with the decoration").type((GraphQLOutputType)Scalars.GraphQLString).build()).field(f -> f.name("feature").description("Extension feature").type((GraphQLOutputType)this.extensionFeatureDescription.getTypeRef())).build();
    }

    private String getData(Decoration<?> p) {
        Object value = p.getData();
        return value == null ? null : JsonUtils.toJSONString((Object)value);
    }
}

