/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.graphql.schema;

import graphql.Scalars;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import net.nemerosa.ontrack.graphql.schema.AbstractGQLProjectEntity;
import net.nemerosa.ontrack.graphql.schema.GQLProjectEntityFieldContributor;
import net.nemerosa.ontrack.graphql.schema.GQLProjectEntityInterface;
import net.nemerosa.ontrack.graphql.schema.GQLTypeBuild;
import net.nemerosa.ontrack.graphql.schema.GQLTypeBuildKt$sam$Function$8e55dbc1;
import net.nemerosa.ontrack.graphql.schema.GQLTypeCache;
import net.nemerosa.ontrack.graphql.schema.GQLTypeCreation;
import net.nemerosa.ontrack.graphql.schema.GQLTypeValidation;
import net.nemerosa.ontrack.graphql.support.GraphqlUtils;
import net.nemerosa.ontrack.model.exceptions.ValidationStampNotFoundException;
import net.nemerosa.ontrack.model.structure.Branch;
import net.nemerosa.ontrack.model.structure.Build;
import net.nemerosa.ontrack.model.structure.ID;
import net.nemerosa.ontrack.model.structure.Project;
import net.nemerosa.ontrack.model.structure.ProjectEntityType;
import net.nemerosa.ontrack.model.structure.PromotionLevel;
import net.nemerosa.ontrack.model.structure.PromotionRun;
import net.nemerosa.ontrack.model.structure.Signature;
import net.nemerosa.ontrack.model.structure.StructureService;
import net.nemerosa.ontrack.model.structure.ValidationRun;
import net.nemerosa.ontrack.model.structure.ValidationStamp;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0017\u0018\u0000 %2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001%B5\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\u0002\u0010\u000eJ\u0014\u0010\u000f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\f0\u0010H\u0012J\u0014\u0010\u0011\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\f0\u0010H\u0012J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0002H\u0012J\u0014\u0010\u0018\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00190\f0\u0010H\u0012J\u0014\u0010\u001a\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140\f0\u0010H\u0012J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0016\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 2\u0006\u0010\"\u001a\u00020\u0002H\u0014J\b\u0010#\u001a\u00020$H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lnet/nemerosa/ontrack/graphql/schema/GQLTypeBuild;", "Lnet/nemerosa/ontrack/graphql/schema/AbstractGQLProjectEntity;", "Lnet/nemerosa/ontrack/model/structure/Build;", "structureService", "Lnet/nemerosa/ontrack/model/structure/StructureService;", "projectEntityInterface", "Lnet/nemerosa/ontrack/graphql/schema/GQLProjectEntityInterface;", "validation", "Lnet/nemerosa/ontrack/graphql/schema/GQLTypeValidation;", "creation", "Lnet/nemerosa/ontrack/graphql/schema/GQLTypeCreation;", "projectEntityFieldContributors", "", "Lnet/nemerosa/ontrack/graphql/schema/GQLProjectEntityFieldContributor;", "(Lnet/nemerosa/ontrack/model/structure/StructureService;Lnet/nemerosa/ontrack/graphql/schema/GQLProjectEntityInterface;Lnet/nemerosa/ontrack/graphql/schema/GQLTypeValidation;Lnet/nemerosa/ontrack/graphql/schema/GQLTypeCreation;Ljava/util/List;)V", "buildLinkedToFetcher", "Lgraphql/schema/DataFetcher;", "buildPromotionRunsFetcher", "Lnet/nemerosa/ontrack/model/structure/PromotionRun;", "buildValidation", "Lnet/nemerosa/ontrack/graphql/schema/GQLTypeValidation$GQLTypeValidationData;", "validationStamp", "Lnet/nemerosa/ontrack/model/structure/ValidationStamp;", "build", "buildValidationRunsFetcher", "Lnet/nemerosa/ontrack/model/structure/ValidationRun;", "buildValidationsFetcher", "createType", "Lgraphql/schema/GraphQLObjectType;", "cache", "Lnet/nemerosa/ontrack/graphql/schema/GQLTypeCache;", "getSignature", "Ljava/util/Optional;", "Lnet/nemerosa/ontrack/model/structure/Signature;", "entity", "getTypeName", "", "Companion", "ontrack-ui-graphql"})
public class GQLTypeBuild
extends AbstractGQLProjectEntity<Build> {
    private final StructureService structureService;
    private final GQLProjectEntityInterface projectEntityInterface;
    private final GQLTypeValidation validation;
    @JvmField
    @NotNull
    public static final String BUILD = "Build";
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public String getTypeName() {
        return BUILD;
    }

    @Override
    @NotNull
    public GraphQLObjectType createType(@NotNull GQLTypeCache cache) {
        Intrinsics.checkParameterIsNotNull((Object)cache, (String)"cache");
        GraphQLObjectType graphQLObjectType = GraphQLObjectType.newObject().name(BUILD).withInterface(this.projectEntityInterface.getTypeRef()).fields(this.projectEntityInterfaceFields()).field(GraphQLFieldDefinition.newFieldDefinition().name("branch").description("Reference to branch").type((GraphQLOutputType)new GraphQLTypeReference("Branch")).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("promotionRuns").description("Promotions for this build").argument(GraphQLArgument.newArgument().name("promotion").description("Name of the promotion level").type((GraphQLInputType)Scalars.GraphQLString).build()).argument(GraphQLArgument.newArgument().name("lastPerLevel").description("Returns the last promotion run per promotion level").type((GraphQLInputType)Scalars.GraphQLBoolean).build()).type(GraphqlUtils.stdList((GraphQLType)new GraphQLTypeReference("PromotionRun"))).dataFetcher(this.buildPromotionRunsFetcher()).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("validationRuns").description("Validations for this build").argument(GraphQLArgument.newArgument().name("validationStamp").description("Name of the validation stamp").type((GraphQLInputType)Scalars.GraphQLString).build()).argument(GraphQLArgument.newArgument().name("count").description("Maximum number of validation runs").type((GraphQLInputType)Scalars.GraphQLInt).defaultValue((Object)50).build()).type(GraphqlUtils.stdList((GraphQLType)new GraphQLTypeReference("ValidationRun"))).dataFetcher(this.buildValidationRunsFetcher()).build()).field((UnaryOperator)new UnaryOperator<GraphQLFieldDefinition.Builder>(this){
            final /* synthetic */ GQLTypeBuild this$0;

            public final GraphQLFieldDefinition.Builder apply(GraphQLFieldDefinition.Builder f) {
                return f.name("validations").description("Validations per validation stamp").argument(GraphQLArgument.newArgument().name("validationStamp").description("Name of the validation stamp").type((GraphQLInputType)Scalars.GraphQLString).build()).type(GraphqlUtils.stdList((GraphQLType)GQLTypeBuild.access$getValidation$p(this.this$0).getTypeRef())).dataFetcher(GQLTypeBuild.access$buildValidationsFetcher(this.this$0));
            }
            {
                this.this$0 = gQLTypeBuild;
            }
        }).field(GraphQLFieldDefinition.newFieldDefinition().name("linkedBuilds").description("Builds this build is linked to").type(GraphqlUtils.stdList((GraphQLType)new GraphQLTypeReference(BUILD))).dataFetcher(this.buildLinkedToFetcher()).build()).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)graphQLObjectType, (String)"newObject()\n            \u2026\n                .build()");
        return graphQLObjectType;
    }

    private DataFetcher<List<GQLTypeValidation.GQLTypeValidationData>> buildValidationsFetcher() {
        DataFetcher dataFetcher2 = GraphqlUtils.fetcher(Build.class, new BiFunction<DataFetchingEnvironment, T, R>(this){
            final /* synthetic */ GQLTypeBuild this$0;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final List<GQLTypeValidation.GQLTypeValidationData> apply(@NotNull DataFetchingEnvironment environment, @NotNull Build build) {
                void $receiver$iv$iv;
                void $receiver$iv;
                Optional<String> validationStampName;
                Intrinsics.checkParameterIsNotNull((Object)environment, (String)"environment");
                Intrinsics.checkParameterIsNotNull((Object)build, (String)"build");
                Optional<String> optional = validationStampName = GraphqlUtils.getStringArgument(environment, "validationStamp");
                Intrinsics.checkExpressionValueIsNotNull(optional, (String)"validationStampName");
                if (optional.isPresent()) {
                    StructureService structureService = GQLTypeBuild.access$getStructureService$p(this.this$0);
                    Project project = build.getProject();
                    Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"build.project");
                    String string = project.getName();
                    Branch branch = build.getBranch();
                    Intrinsics.checkExpressionValueIsNotNull((Object)branch, (String)"build.branch");
                    ValidationStamp validationStamp2 = structureService.findValidationStampByName(string, branch.getName(), validationStampName.get()).orElse(null);
                    if (validationStamp2 != null) {
                        return CollectionsKt.listOf((Object)GQLTypeBuild.access$buildValidation(this.this$0, validationStamp2, build));
                    }
                    return CollectionsKt.emptyList();
                }
                StructureService structureService = GQLTypeBuild.access$getStructureService$p(this.this$0);
                Branch branch = build.getBranch();
                Intrinsics.checkExpressionValueIsNotNull((Object)branch, (String)"build.branch");
                List list = structureService.getValidationStampListForBranch(branch.getId());
                Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"structureService.getVali\u2026orBranch(build.branch.id)");
                Iterable validationStamp2 = list;
                void var5_6 = $receiver$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                for (T item$iv$iv : $receiver$iv$iv) {
                    void validationStamp3;
                    ValidationStamp validationStamp4 = (ValidationStamp)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    void v8 = validationStamp3;
                    Intrinsics.checkExpressionValueIsNotNull((Object)v8, (String)"validationStamp");
                    GQLTypeValidation.GQLTypeValidationData gQLTypeValidationData = GQLTypeBuild.access$buildValidation(this.this$0, (ValidationStamp)v8, build);
                    collection.add(gQLTypeValidationData);
                }
                return (List)destination$iv$iv;
            }
            {
                this.this$0 = gQLTypeBuild;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull(dataFetcher2, (String)"fetcher(\n               \u2026}\n            }\n        }");
        return dataFetcher2;
    }

    private GQLTypeValidation.GQLTypeValidationData buildValidation(ValidationStamp validationStamp2, Build build) {
        List list = this.structureService.getValidationRunsForBuildAndValidationStamp(build.getId(), validationStamp2.getId());
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"structureService.getVali\u2026tamp.id\n                )");
        return new GQLTypeValidation.GQLTypeValidationData(validationStamp2, list);
    }

    private DataFetcher<List<Build>> buildLinkedToFetcher() {
        Function1 function1 = (Function1)new Function1<Build, List<Build>>(this.structureService){

            public final List<Build> invoke(Build p1) {
                return ((StructureService)this.receiver).getBuildLinksFrom(p1);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(StructureService.class);
            }

            public final String getName() {
                return "getBuildLinksFrom";
            }

            public final String getSignature() {
                return "getBuildLinksFrom(Lnet/nemerosa/ontrack/model/structure/Build;)Ljava/util/List;";
            }
        };
        DataFetcher dataFetcher2 = GraphqlUtils.fetcher(Build.class, new GQLTypeBuildKt$sam$Function$8e55dbc1(function1));
        Intrinsics.checkExpressionValueIsNotNull(dataFetcher2, (String)"fetcher(\n               \u2026tBuildLinksFrom\n        )");
        return dataFetcher2;
    }

    private DataFetcher<List<ValidationRun>> buildValidationRunsFetcher() {
        return (DataFetcher)new DataFetcher<List<? extends ValidationRun>>(this){
            final /* synthetic */ GQLTypeBuild this$0;

            public final List<ValidationRun> get(DataFetchingEnvironment environment) {
                Object object = environment.getSource();
                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"environment.getSource()");
                Build build = (Build)object;
                int count = GraphqlUtils.getIntArgument(environment, "count").orElse(50);
                String validation = GraphqlUtils.getStringArgument(environment, "validation").orElse(null);
                if (validation != null) {
                    StructureService structureService = GQLTypeBuild.access$getStructureService$p(this.this$0);
                    Project project = build.getProject();
                    Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"build.project");
                    String string = project.getName();
                    Branch branch = build.getBranch();
                    Intrinsics.checkExpressionValueIsNotNull((Object)branch, (String)"build.branch");
                    ValidationStamp validationStamp2 = (ValidationStamp)structureService.findValidationStampByName(string, branch.getName(), validation).orElseThrow((Supplier)new Supplier<X>(build, validation){
                        final /* synthetic */ Build $build;
                        final /* synthetic */ String $validation;

                        @NotNull
                        public final ValidationStampNotFoundException get() {
                            Project project = this.$build.getProject();
                            Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"build.project");
                            String string = project.getName();
                            Branch branch = this.$build.getBranch();
                            Intrinsics.checkExpressionValueIsNotNull((Object)branch, (String)"build.branch");
                            return new ValidationStampNotFoundException(string, branch.getName(), this.$validation);
                        }
                        {
                            this.$build = build;
                            this.$validation = string;
                        }
                    });
                    StructureService structureService2 = GQLTypeBuild.access$getStructureService$p(this.this$0);
                    ID iD = build.getId();
                    ValidationStamp validationStamp3 = validationStamp2;
                    Intrinsics.checkExpressionValueIsNotNull((Object)validationStamp3, (String)"validationStamp");
                    List list = structureService2.getValidationRunsForBuildAndValidationStamp(iD, validationStamp3.getId());
                    Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"structureService.getVali\u2026.id\n                    )");
                    return CollectionsKt.take((Iterable)list, (int)count);
                }
                List list = GQLTypeBuild.access$getStructureService$p(this.this$0).getValidationRunsForBuild(build.getId());
                Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"structureService.getVali\u2026ionRunsForBuild(build.id)");
                return CollectionsKt.take((Iterable)list, (int)count);
            }
            {
                this.this$0 = gQLTypeBuild;
            }
        };
    }

    private DataFetcher<List<PromotionRun>> buildPromotionRunsFetcher() {
        return (DataFetcher)new DataFetcher<List<? extends PromotionRun>>(this){
            final /* synthetic */ GQLTypeBuild this$0;

            public final List<PromotionRun> get(DataFetchingEnvironment environment) {
                PromotionLevel promotionLevel;
                PromotionLevel promotionLevel2;
                Object object = environment.getSource();
                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"environment.getSource()");
                Build build = (Build)object;
                boolean lastPerLevel = GraphqlUtils.getBooleanArgument(environment, "lastPerLevel", false);
                String promotion = GraphqlUtils.getStringArgument(environment, "promotion").orElse(null);
                if (promotion != null) {
                    StructureService structureService = GQLTypeBuild.access$getStructureService$p(this.this$0);
                    Project project = build.getProject();
                    Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"build.project");
                    String string = project.getName();
                    Branch branch = build.getBranch();
                    Intrinsics.checkExpressionValueIsNotNull((Object)branch, (String)"build.branch");
                    promotionLevel2 = structureService.findPromotionLevelByName(string, branch.getName(), promotion).orElse(null);
                } else {
                    promotionLevel2 = promotionLevel = null;
                }
                if (promotionLevel != null) {
                    if (lastPerLevel) {
                        Optional<U> optional = GQLTypeBuild.access$getStructureService$p(this.this$0).getLastPromotionRunForBuildAndPromotionLevel(build, promotionLevel).map(buildPromotionRunsFetcher.1.INSTANCE);
                        List list = CollectionsKt.emptyList();
                        return optional.orElse(list);
                    }
                    return GQLTypeBuild.access$getStructureService$p(this.this$0).getPromotionRunsForBuildAndPromotionLevel(build, promotionLevel);
                }
                if (lastPerLevel) {
                    return GQLTypeBuild.access$getStructureService$p(this.this$0).getLastPromotionRunsForBuild(build.getId());
                }
                return GQLTypeBuild.access$getStructureService$p(this.this$0).getPromotionRunsForBuild(build.getId());
            }
            {
                this.this$0 = gQLTypeBuild;
            }
        };
    }

    @Override
    @NotNull
    protected Optional<Signature> getSignature(@NotNull Build entity) {
        Intrinsics.checkParameterIsNotNull((Object)entity, (String)"entity");
        Optional<Signature> optional = Optional.ofNullable(entity.getSignature());
        Intrinsics.checkExpressionValueIsNotNull(optional, (String)"Optional.ofNullable(entity.signature)");
        return optional;
    }

    @Autowired
    public GQLTypeBuild(@NotNull StructureService structureService, @NotNull GQLProjectEntityInterface projectEntityInterface, @NotNull GQLTypeValidation validation, @NotNull GQLTypeCreation creation, @NotNull List<? extends GQLProjectEntityFieldContributor> projectEntityFieldContributors) {
        Intrinsics.checkParameterIsNotNull((Object)structureService, (String)"structureService");
        Intrinsics.checkParameterIsNotNull((Object)projectEntityInterface, (String)"projectEntityInterface");
        Intrinsics.checkParameterIsNotNull((Object)validation, (String)"validation");
        Intrinsics.checkParameterIsNotNull((Object)creation, (String)"creation");
        Intrinsics.checkParameterIsNotNull(projectEntityFieldContributors, (String)"projectEntityFieldContributors");
        super(Build.class, ProjectEntityType.BUILD, projectEntityFieldContributors, creation);
        this.structureService = structureService;
        this.projectEntityInterface = projectEntityInterface;
        this.validation = validation;
    }

    static {
        BUILD = BUILD;
    }

    @NotNull
    public static final /* synthetic */ GQLTypeValidation access$getValidation$p(GQLTypeBuild $this) {
        return $this.validation;
    }

    @NotNull
    public static final /* synthetic */ DataFetcher access$buildValidationsFetcher(GQLTypeBuild $this) {
        return $this.buildValidationsFetcher();
    }

    @NotNull
    public static final /* synthetic */ StructureService access$getStructureService$p(GQLTypeBuild $this) {
        return $this.structureService;
    }

    @NotNull
    public static final /* synthetic */ GQLTypeValidation.GQLTypeValidationData access$buildValidation(GQLTypeBuild $this, @NotNull ValidationStamp validationStamp2, @NotNull Build build) {
        return $this.buildValidation(validationStamp2, build);
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lnet/nemerosa/ontrack/graphql/schema/GQLTypeBuild$Companion;", "", "()V", "BUILD", "", "ontrack-ui-graphql"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

