/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.graphql.schema;

import graphql.Scalars;
import graphql.schema.DataFetcher;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeReference;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.nemerosa.ontrack.graphql.schema.AbstractGQLProjectEntity;
import net.nemerosa.ontrack.graphql.schema.GQLInputBuildGenericFilter;
import net.nemerosa.ontrack.graphql.schema.GQLInputBuildStandardFilter;
import net.nemerosa.ontrack.graphql.schema.GQLProjectEntityFieldContributor;
import net.nemerosa.ontrack.graphql.schema.GQLProjectEntityInterface;
import net.nemerosa.ontrack.graphql.schema.GQLTypeBuild;
import net.nemerosa.ontrack.graphql.schema.GQLTypeCache;
import net.nemerosa.ontrack.graphql.schema.GQLTypeCreation;
import net.nemerosa.ontrack.graphql.schema.GQLTypePromotionLevel;
import net.nemerosa.ontrack.graphql.schema.GQLTypeValidationStamp;
import net.nemerosa.ontrack.graphql.support.GraphqlUtils;
import net.nemerosa.ontrack.model.buildfilter.BuildFilterService;
import net.nemerosa.ontrack.model.structure.Branch;
import net.nemerosa.ontrack.model.structure.BranchType;
import net.nemerosa.ontrack.model.structure.ProjectEntityType;
import net.nemerosa.ontrack.model.structure.Signature;
import net.nemerosa.ontrack.model.structure.StructureService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class GQLTypeBranch
extends AbstractGQLProjectEntity<Branch> {
    public static final String BRANCH = "Branch";
    private final StructureService structureService;
    private final BuildFilterService buildFilterService;
    private final GQLTypeBuild build;
    private final GQLTypePromotionLevel promotionLevel;
    private final GQLTypeValidationStamp validationStamp;
    private final GQLInputBuildStandardFilter inputBuildStandardFilter;
    private final GQLInputBuildGenericFilter inputBuildGenericFilter;
    private final GQLProjectEntityInterface projectEntityInterface;

    @Autowired
    public GQLTypeBranch(StructureService structureService, BuildFilterService buildFilterService, GQLTypeCreation creation, GQLTypeBuild build, GQLTypePromotionLevel promotionLevel, GQLTypeValidationStamp validationStamp2, GQLInputBuildStandardFilter inputBuildStandardFilter, List<GQLProjectEntityFieldContributor> projectEntityFieldContributors, GQLInputBuildGenericFilter inputBuildGenericFilter, GQLProjectEntityInterface projectEntityInterface) {
        super(Branch.class, ProjectEntityType.BRANCH, projectEntityFieldContributors, creation);
        this.structureService = structureService;
        this.buildFilterService = buildFilterService;
        this.build = build;
        this.promotionLevel = promotionLevel;
        this.validationStamp = validationStamp2;
        this.inputBuildStandardFilter = inputBuildStandardFilter;
        this.inputBuildGenericFilter = inputBuildGenericFilter;
        this.projectEntityInterface = projectEntityInterface;
    }

    @Override
    public String getTypeName() {
        return BRANCH;
    }

    @Override
    public GraphQLObjectType createType(GQLTypeCache cache) {
        return GraphQLObjectType.newObject().name(BRANCH).withInterface(this.projectEntityInterface.getTypeRef()).fields(this.projectEntityInterfaceFields()).field(GraphqlUtils.disabledField()).field(GraphQLFieldDefinition.newFieldDefinition().name("type").type(GraphqlUtils.newEnumType(BranchType.class)).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("project").description("Reference to project").type((GraphQLOutputType)new GraphQLTypeReference("Project")).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("promotionLevels").type(GraphqlUtils.stdList((GraphQLType)this.promotionLevel.getTypeRef())).dataFetcher(this.branchPromotionLevelsFetcher()).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("validationStamps").type(GraphqlUtils.stdList((GraphQLType)this.validationStamp.getTypeRef())).argument(arg -> arg.name("name").description("Filters on the validation stamp").type((GraphQLInputType)Scalars.GraphQLString)).dataFetcher(this.branchValidationStampsFetcher()).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("builds").type(GraphqlUtils.stdList((GraphQLType)this.build.getTypeRef())).argument(GraphQLArgument.newArgument().name("count").description("Maximum number of builds to return").type((GraphQLInputType)Scalars.GraphQLInt).build()).argument(GraphQLArgument.newArgument().name("lastPromotions").description("Filter which returns the last promoted builds").type((GraphQLInputType)Scalars.GraphQLBoolean).build()).argument(GraphQLArgument.newArgument().name("filter").description("Filter based on build promotions, validations, properties, ...").type((GraphQLInputType)this.inputBuildStandardFilter.getTypeRef()).build()).argument(GraphQLArgument.newArgument().name("generic").description("Generic filter based on a configured filter").type((GraphQLInputType)this.inputBuildGenericFilter.getTypeRef()).build()).dataFetcher(this.branchBuildsFetcher()).build()).build();
    }

    private DataFetcher branchBuildsFetcher() {
        return environment -> {
            Object source = environment.getSource();
            if (source instanceof Branch) {
                Branch branch = (Branch)source;
                int count = GraphqlUtils.getIntArgument(environment, "count").orElse(10);
                Object filter2 = environment.getArgument("filter");
                Object genericFilter = environment.getArgument("generic");
                boolean lastPromotions = GraphqlUtils.getBooleanArgument(environment, "lastPromotions", false);
                Object buildFilter = lastPromotions ? this.buildFilterService.lastPromotedBuildsFilterData() : (filter2 != null ? this.inputBuildStandardFilter.convert(filter2) : (genericFilter != null ? this.inputBuildGenericFilter.convert(genericFilter) : this.buildFilterService.standardFilterProviderData(count).build()));
                return buildFilter.filterBranchBuilds(branch);
            }
            return Collections.emptyList();
        };
    }

    private DataFetcher branchPromotionLevelsFetcher() {
        return environment -> {
            Object source = environment.getSource();
            if (source instanceof Branch) {
                Branch branch = (Branch)source;
                return this.structureService.getPromotionLevelListForBranch(branch.getId());
            }
            return Collections.emptyList();
        };
    }

    private DataFetcher branchValidationStampsFetcher() {
        return environment -> {
            Object source = environment.getSource();
            Optional<String> name = GraphqlUtils.getStringArgument(environment, "name");
            if (source instanceof Branch) {
                Branch branch = (Branch)source;
                if (name.isPresent()) {
                    return this.structureService.findValidationStampByName(branch.getProject().getName(), branch.getName(), name.get()).map(Collections::singletonList).orElse(Collections.emptyList());
                }
                return this.structureService.getValidationStampListForBranch(branch.getId());
            }
            return Collections.emptyList();
        };
    }

    @Override
    protected Optional<Signature> getSignature(Branch entity) {
        return Optional.ofNullable(entity.getSignature());
    }
}

