/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.graphql.schema;

import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeReference;
import net.nemerosa.ontrack.graphql.schema.GQLType;
import net.nemerosa.ontrack.graphql.schema.GQLTypeCache;
import net.nemerosa.ontrack.graphql.schema.GQLTypeProjectRole;
import net.nemerosa.ontrack.graphql.support.GraphqlUtils;
import net.nemerosa.ontrack.model.security.ProjectRoleAssociation;
import net.nemerosa.ontrack.model.structure.ID;
import net.nemerosa.ontrack.model.structure.StructureService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class GQLTypeAuthorizedProject
implements GQLType {
    public static final String AUTHORIZED_PROJECT = "AuthorizedProject";
    private final GQLTypeProjectRole projectRole;
    private final StructureService structureService;

    @Autowired
    public GQLTypeAuthorizedProject(GQLTypeProjectRole projectRole, StructureService structureService) {
        this.projectRole = projectRole;
        this.structureService = structureService;
    }

    @Override
    public String getTypeName() {
        return AUTHORIZED_PROJECT;
    }

    @Override
    public GraphQLObjectType createType(GQLTypeCache cache) {
        return GraphQLObjectType.newObject().name(AUTHORIZED_PROJECT).field(GraphQLFieldDefinition.newFieldDefinition().name("role").description("Role for the project").type((GraphQLOutputType)new GraphQLNonNull((GraphQLType)this.projectRole.getTypeRef())).dataFetcher(GraphqlUtils.fetcher(ProjectRoleAssociation.class, ProjectRoleAssociation::getProjectRole)).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("project").description("Authorized project").type((GraphQLOutputType)new GraphQLNonNull((GraphQLType)new GraphQLTypeReference("Project"))).dataFetcher(GraphqlUtils.fetcher(ProjectRoleAssociation.class, pra -> this.structureService.getProject(ID.of((int)pra.getProjectId())))).build()).build();
    }
}

