/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.graphql.schema;

import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeReference;
import java.util.List;
import net.nemerosa.ontrack.graphql.schema.GQLType;
import net.nemerosa.ontrack.graphql.schema.GQLTypeAccountGroupMapping;
import net.nemerosa.ontrack.graphql.schema.GQLTypeAuthorizedProject;
import net.nemerosa.ontrack.graphql.schema.GQLTypeCache;
import net.nemerosa.ontrack.graphql.schema.GQLTypeGlobalRole;
import net.nemerosa.ontrack.graphql.support.GraphqlUtils;
import net.nemerosa.ontrack.model.security.Account;
import net.nemerosa.ontrack.model.security.AccountGroup;
import net.nemerosa.ontrack.model.security.AccountGroupMappingService;
import net.nemerosa.ontrack.model.security.AccountService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class GQLTypeAccountGroup
implements GQLType {
    public static final String ACCOUNT_GROUP = "AccountGroup";
    public static final String ACCOUNTS_FIELD = "accounts";
    private final AccountService accountService;
    private final AccountGroupMappingService accountGroupMappingService;
    private final GQLTypeGlobalRole globalRole;
    private final GQLTypeAuthorizedProject authorizedProject;
    private final GQLTypeAccountGroupMapping accountGroupMapping;

    @Autowired
    public GQLTypeAccountGroup(AccountService accountService, AccountGroupMappingService accountGroupMappingService, GQLTypeGlobalRole globalRole, GQLTypeAuthorizedProject authorizedProject, GQLTypeAccountGroupMapping accountGroupMapping) {
        this.accountService = accountService;
        this.accountGroupMappingService = accountGroupMappingService;
        this.globalRole = globalRole;
        this.authorizedProject = authorizedProject;
        this.accountGroupMapping = accountGroupMapping;
    }

    @Override
    public String getTypeName() {
        return ACCOUNT_GROUP;
    }

    @Override
    public GraphQLObjectType createType(GQLTypeCache cache) {
        return GraphQLObjectType.newObject().name(ACCOUNT_GROUP).field(GraphqlUtils.idField()).field(GraphqlUtils.nameField()).field(GraphqlUtils.descriptionField()).field(field -> field.name(ACCOUNTS_FIELD).description("List of associated accounts").type(GraphqlUtils.stdList((GraphQLType)new GraphQLTypeReference("Account"))).dataFetcher(GraphqlUtils.fetcher(AccountGroup.class, this::getAccountsForGroup))).field(field -> field.name("globalRole").description("Global role for the account group").type((GraphQLOutputType)this.globalRole.getTypeRef()).dataFetcher(GraphqlUtils.fetcher(AccountGroup.class, group -> this.accountService.getGlobalRoleForAccountGroup(group).orElse(null)))).field(field -> field.name("authorizedProjects").description("List of authorized projects").type(GraphqlUtils.stdList((GraphQLType)this.authorizedProject.getTypeRef())).dataFetcher(GraphqlUtils.fetcher(AccountGroup.class, arg_0 -> ((AccountService)this.accountService).getProjectPermissionsForAccountGroup(arg_0)))).field(field -> field.name("mappings").description("Mappings for this group").type(GraphqlUtils.stdList((GraphQLType)this.accountGroupMapping.getTypeRef())).dataFetcher(GraphqlUtils.fetcher(AccountGroup.class, arg_0 -> ((AccountGroupMappingService)this.accountGroupMappingService).getMappingsForGroup(arg_0)))).build();
    }

    private List<Account> getAccountsForGroup(AccountGroup accountGroup) {
        return this.accountService.getAccountsForGroup(accountGroup);
    }
}

