/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.graphql.schema;

import graphql.Scalars;
import graphql.schema.DataFetcher;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeReference;
import net.nemerosa.ontrack.graphql.schema.GQLType;
import net.nemerosa.ontrack.graphql.schema.GQLTypeAuthorizedProject;
import net.nemerosa.ontrack.graphql.schema.GQLTypeCache;
import net.nemerosa.ontrack.graphql.schema.GQLTypeGlobalRole;
import net.nemerosa.ontrack.graphql.support.GraphqlUtils;
import net.nemerosa.ontrack.model.security.Account;
import net.nemerosa.ontrack.model.security.AccountService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class GQLTypeAccount
implements GQLType {
    public static final String ACCOUNT = "Account";
    private final AccountService accountService;
    private final GQLTypeGlobalRole globalRole;
    private final GQLTypeAuthorizedProject authorizedProject;

    @Autowired
    public GQLTypeAccount(AccountService accountService, GQLTypeGlobalRole globalRole, GQLTypeAuthorizedProject authorizedProject) {
        this.accountService = accountService;
        this.globalRole = globalRole;
        this.authorizedProject = authorizedProject;
    }

    @Override
    public String getTypeName() {
        return ACCOUNT;
    }

    @Override
    public GraphQLObjectType createType(GQLTypeCache cache) {
        return GraphQLObjectType.newObject().name(ACCOUNT).field(GraphqlUtils.idField()).field(GraphqlUtils.nameField("Unique name for the account")).field(GraphqlUtils.stringField("fullName", "Full name of the account")).field(GraphqlUtils.stringField("email", "Email of the account")).field(GraphQLFieldDefinition.newFieldDefinition().name("authenticationSource").description("Source of authentication (builtin, ldap, etc.)").type((GraphQLOutputType)Scalars.GraphQLString).dataFetcher(environment -> ((Account)environment.getSource()).getAuthenticationSource().getId()).build()).field(GraphqlUtils.stringField("role", "Security role (admin or none)")).field(GraphQLFieldDefinition.newFieldDefinition().name("groups").description("List of groups the account belongs to").type(GraphqlUtils.stdList((GraphQLType)new GraphQLTypeReference("AccountGroup"))).dataFetcher(this.accountAccountGroupsFetcher()).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("globalRole").description("Global role for the account").type((GraphQLOutputType)this.globalRole.getTypeRef()).dataFetcher(this.accountGlobalRoleFetcher()).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("authorizedProjects").description("List of authorized projects").type(GraphqlUtils.stdList((GraphQLType)this.authorizedProject.getTypeRef())).dataFetcher(this.accountAuthorizedProjectsFetcher()).build()).build();
    }

    private DataFetcher accountAuthorizedProjectsFetcher() {
        return GraphqlUtils.fetcher(Account.class, arg_0 -> ((AccountService)this.accountService).getProjectPermissionsForAccount(arg_0));
    }

    private DataFetcher accountGlobalRoleFetcher() {
        return GraphqlUtils.fetcher(Account.class, account -> this.accountService.getGlobalRoleForAccount(account).orElse(null));
    }

    private DataFetcher accountAccountGroupsFetcher() {
        return GraphqlUtils.fetcher(Account.class, Account::getAccountGroups);
    }
}

