/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.graphql.schema;

import graphql.Scalars;
import graphql.schema.DataFetcher;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLType;
import java.util.Collections;
import net.nemerosa.ontrack.graphql.schema.GQLRootQuery;
import net.nemerosa.ontrack.graphql.schema.GQLTypePromotionRun;
import net.nemerosa.ontrack.graphql.support.GraphqlUtils;
import net.nemerosa.ontrack.model.structure.ID;
import net.nemerosa.ontrack.model.structure.StructureService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class GQLRootQueryPromotionRuns
implements GQLRootQuery {
    private final StructureService structureService;
    private final GQLTypePromotionRun promotionRun;

    @Autowired
    public GQLRootQueryPromotionRuns(StructureService structureService, GQLTypePromotionRun promotionRun) {
        this.structureService = structureService;
        this.promotionRun = promotionRun;
    }

    @Override
    public GraphQLFieldDefinition getFieldDefinition() {
        return GraphQLFieldDefinition.newFieldDefinition().name("promotionRuns").type(GraphqlUtils.stdList((GraphQLType)this.promotionRun.getTypeRef())).argument(GraphQLArgument.newArgument().name("id").description("ID of the promotion run to look for").type((GraphQLInputType)new GraphQLNonNull((GraphQLType)Scalars.GraphQLInt)).build()).dataFetcher(this.promotionRunFetcher()).build();
    }

    private DataFetcher promotionRunFetcher() {
        return environment -> {
            Integer id = (Integer)environment.getArgument("id");
            if (id != null) {
                return Collections.singletonList(this.structureService.getPromotionRun(ID.of((int)id)));
            }
            return Collections.emptyList();
        };
    }
}

