/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.graphql.schema;

import graphql.Scalars;
import graphql.schema.DataFetcher;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLType;
import java.util.Collections;
import java.util.Optional;
import net.nemerosa.ontrack.graphql.schema.GQLInputBuildSearchForm;
import net.nemerosa.ontrack.graphql.schema.GQLInputBuildStandardFilter;
import net.nemerosa.ontrack.graphql.schema.GQLRootQuery;
import net.nemerosa.ontrack.graphql.schema.GQLTypeBuild;
import net.nemerosa.ontrack.graphql.support.GraphqlUtils;
import net.nemerosa.ontrack.model.buildfilter.BuildFilterProviderData;
import net.nemerosa.ontrack.model.exceptions.BranchNotFoundException;
import net.nemerosa.ontrack.model.exceptions.ProjectNotFoundException;
import net.nemerosa.ontrack.model.structure.Branch;
import net.nemerosa.ontrack.model.structure.BuildSearchForm;
import net.nemerosa.ontrack.model.structure.ID;
import net.nemerosa.ontrack.model.structure.Project;
import net.nemerosa.ontrack.model.structure.StructureService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class GQLRootQueryBuilds
implements GQLRootQuery {
    public static final String PROJECT_ARGUMENT = "project";
    public static final String BRANCH_ARGUMENT = "branch";
    public static final String BUILD_BRANCH_FILTER_ARGUMENT = "buildBranchFilter";
    public static final String BUILD_PROJECT_FILTER_ARGUMENT = "buildProjectFilter";
    private final StructureService structureService;
    private final GQLTypeBuild build;
    private final GQLInputBuildStandardFilter inputBuildStandardFilter;
    private final GQLInputBuildSearchForm inputBuildSearchForm;

    @Autowired
    public GQLRootQueryBuilds(StructureService structureService, GQLTypeBuild build, GQLInputBuildStandardFilter inputBuildStandardFilter, GQLInputBuildSearchForm inputBuildSearchForm) {
        this.structureService = structureService;
        this.build = build;
        this.inputBuildStandardFilter = inputBuildStandardFilter;
        this.inputBuildSearchForm = inputBuildSearchForm;
    }

    @Override
    public GraphQLFieldDefinition getFieldDefinition() {
        return GraphQLFieldDefinition.newFieldDefinition().name("builds").type(GraphqlUtils.stdList((GraphQLType)this.build.getTypeRef())).argument(GraphQLArgument.newArgument().name("id").description("ID of the build to look for").type((GraphQLInputType)Scalars.GraphQLInt).build()).argument(GraphQLArgument.newArgument().name(PROJECT_ARGUMENT).description("Name of a project").type((GraphQLInputType)Scalars.GraphQLString).build()).argument(GraphQLArgument.newArgument().name(BRANCH_ARGUMENT).description("Name of a branch - requires 'project' to be filled as well").type((GraphQLInputType)Scalars.GraphQLString).build()).argument(GraphQLArgument.newArgument().name(BUILD_BRANCH_FILTER_ARGUMENT).description("Filter to apply for the builds on the branch - requires 'branch' to be filled.").type((GraphQLInputType)this.inputBuildStandardFilter.getTypeRef()).build()).argument(GraphQLArgument.newArgument().name(BUILD_PROJECT_FILTER_ARGUMENT).description("Filter to apply for the builds on the project - requires 'project' to be filled.").type((GraphQLInputType)this.inputBuildSearchForm.getTypeRef()).build()).dataFetcher(this.buildFetcher()).build();
    }

    private DataFetcher buildFetcher() {
        return environment -> {
            Integer id = (Integer)environment.getArgument("id");
            Optional<String> oProject = GraphqlUtils.getStringArgument(environment, PROJECT_ARGUMENT);
            Optional<String> oBranch = GraphqlUtils.getStringArgument(environment, BRANCH_ARGUMENT);
            Object branchFilter = environment.getArgument(BUILD_BRANCH_FILTER_ARGUMENT);
            Object projectFilter = environment.getArgument(BUILD_PROJECT_FILTER_ARGUMENT);
            if (id != null) {
                GraphqlUtils.checkArgList(environment, "id");
                return Collections.singletonList(this.structureService.getBuild(ID.of((int)id)));
            }
            if (oProject.isPresent()) {
                if (oBranch.isPresent()) {
                    Branch branch = (Branch)this.structureService.findBranchByName(oProject.get(), oBranch.get()).orElseThrow(() -> new BranchNotFoundException((String)oProject.get(), (String)oBranch.get()));
                    BuildFilterProviderData<?> filter2 = this.inputBuildStandardFilter.convert(branchFilter);
                    return filter2.filterBranchBuilds(branch);
                }
                Project project = (Project)this.structureService.findProjectByName(oProject.get()).orElseThrow(() -> new ProjectNotFoundException((String)oProject.get()));
                BuildSearchForm form = this.inputBuildSearchForm.convert(projectFilter);
                return this.structureService.buildSearch(project.getId(), form);
            }
            if (branchFilter != null) {
                throw new IllegalStateException(String.format("%s must be used together with %s", BUILD_BRANCH_FILTER_ARGUMENT, BRANCH_ARGUMENT));
            }
            if (projectFilter != null) {
                throw new IllegalStateException(String.format("%s must be used together with %s", BUILD_PROJECT_FILTER_ARGUMENT, PROJECT_ARGUMENT));
            }
            return Collections.emptyList();
        };
    }
}

