/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.graphql.schema;

import graphql.Scalars;
import graphql.schema.DataFetcher;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLType;
import java.util.Collections;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.nemerosa.ontrack.graphql.schema.GQLInputPropertyFilter;
import net.nemerosa.ontrack.graphql.schema.GQLRootQuery;
import net.nemerosa.ontrack.graphql.schema.GQLTypeBranch;
import net.nemerosa.ontrack.graphql.schema.PropertyFilter;
import net.nemerosa.ontrack.graphql.support.GraphqlUtils;
import net.nemerosa.ontrack.model.structure.Branch;
import net.nemerosa.ontrack.model.structure.ID;
import net.nemerosa.ontrack.model.structure.Project;
import net.nemerosa.ontrack.model.structure.StructureService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class GQLRootQueryBranches
implements GQLRootQuery {
    private final StructureService structureService;
    private final GQLTypeBranch branch;
    private final GQLInputPropertyFilter propertyFilter;

    @Autowired
    public GQLRootQueryBranches(StructureService structureService, GQLTypeBranch branch, GQLInputPropertyFilter propertyFilter) {
        this.structureService = structureService;
        this.branch = branch;
        this.propertyFilter = propertyFilter;
    }

    @Override
    public GraphQLFieldDefinition getFieldDefinition() {
        return GraphQLFieldDefinition.newFieldDefinition().name("branches").type(GraphqlUtils.stdList((GraphQLType)this.branch.getTypeRef())).argument(GraphQLArgument.newArgument().name("id").description("ID of the branch to look for").type((GraphQLInputType)Scalars.GraphQLInt).build()).argument(GraphQLArgument.newArgument().name("project").description("Name of the project the branch belongs to").type((GraphQLInputType)Scalars.GraphQLString).build()).argument(GraphQLArgument.newArgument().name("name").description("Regular expression to match against the branch name").type((GraphQLInputType)Scalars.GraphQLString).build()).argument(this.propertyFilter.asArgument()).dataFetcher(this.branchFetcher()).build();
    }

    private DataFetcher branchFetcher() {
        return environment -> {
            Integer id = (Integer)environment.getArgument("id");
            String projectName = (String)environment.getArgument("project");
            String name = (String)environment.getArgument("name");
            Object propertyFilterArg = environment.getArgument("withProperty");
            if (id != null) {
                GraphqlUtils.checkArgList(environment, "id");
                return Collections.singletonList(this.structureService.getBranch(ID.of((int)id)));
            }
            if (StringUtils.isNotBlank((CharSequence)projectName) || StringUtils.isNotBlank((CharSequence)name) || propertyFilterArg != null) {
                PropertyFilter filterObject;
                Predicate<Project> projectFilter = p -> true;
                if (StringUtils.isNotBlank((CharSequence)projectName)) {
                    projectFilter = projectFilter.and(project -> StringUtils.equals((CharSequence)projectName, (CharSequence)project.getName()));
                }
                Predicate<Branch> branchFilter = b -> true;
                if (StringUtils.isNotBlank((CharSequence)name)) {
                    Pattern pattern = Pattern.compile(name);
                    branchFilter = branchFilter.and(b -> pattern.matcher(b.getName()).matches());
                }
                if (propertyFilterArg != null && (filterObject = this.propertyFilter.convert(propertyFilterArg)) != null && StringUtils.isNotBlank((CharSequence)filterObject.getType())) {
                    branchFilter = branchFilter.and(this.propertyFilter.getFilter(filterObject));
                }
                return this.structureService.getProjectList().stream().filter(projectFilter).flatMap(project -> this.structureService.getBranchesForProject(project.getId()).stream()).filter(branchFilter).collect(Collectors.toList());
            }
            return Collections.emptyList();
        };
    }
}

