/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.graphql.schema;

import graphql.Scalars;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLType;
import java.util.Collections;
import net.nemerosa.ontrack.graphql.schema.GQLRootQuery;
import net.nemerosa.ontrack.graphql.schema.GQLTypeGlobalRole;
import net.nemerosa.ontrack.graphql.support.GraphqlUtils;
import net.nemerosa.ontrack.model.exceptions.RoleNotFoundException;
import net.nemerosa.ontrack.model.security.RolesService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class GQLRootQueryAdminGlobalRoles
implements GQLRootQuery {
    private final GQLTypeGlobalRole globalRole;
    private final RolesService rolesService;

    @Autowired
    public GQLRootQueryAdminGlobalRoles(GQLTypeGlobalRole globalRole, RolesService rolesService) {
        this.globalRole = globalRole;
        this.rolesService = rolesService;
    }

    @Override
    public GraphQLFieldDefinition getFieldDefinition() {
        return GraphQLFieldDefinition.newFieldDefinition().name("globalRoles").description("List of global security roles").type(GraphqlUtils.stdList((GraphQLType)this.globalRole.getTypeRef())).argument(a -> a.name("role").description("Filter by role name").type((GraphQLInputType)Scalars.GraphQLString)).dataFetcher(environment -> GraphqlUtils.getStringArgument(environment, "role").map(name -> Collections.singletonList(this.rolesService.getGlobalRole(name).orElseThrow(() -> new RoleNotFoundException(name)))).orElse(this.rolesService.getGlobalRoles())).build();
    }
}

