/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.graphql.schema;

import graphql.Scalars;
import graphql.schema.DataFetcher;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLType;
import java.util.Collections;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.nemerosa.ontrack.graphql.schema.GQLRootQuery;
import net.nemerosa.ontrack.graphql.schema.GQLTypeAccount;
import net.nemerosa.ontrack.graphql.support.GraphqlUtils;
import net.nemerosa.ontrack.model.security.Account;
import net.nemerosa.ontrack.model.security.AccountService;
import net.nemerosa.ontrack.model.structure.ID;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class GQLRootQueryAdminAccounts
implements GQLRootQuery {
    public static final String ID_ARGUMENT = "id";
    public static final String NAME_ARGUMENT = "name";
    public static final String GROUP_ARGUMENT = "group";
    private final AccountService accountService;
    private final GQLTypeAccount account;

    @Autowired
    public GQLRootQueryAdminAccounts(AccountService accountService, GQLTypeAccount account) {
        this.accountService = accountService;
        this.account = account;
    }

    @Override
    public GraphQLFieldDefinition getFieldDefinition() {
        return GraphQLFieldDefinition.newFieldDefinition().name("accounts").type(GraphqlUtils.stdList((GraphQLType)this.account.getTypeRef())).argument(GraphQLArgument.newArgument().name(ID_ARGUMENT).description("Searching by ID").type((GraphQLInputType)Scalars.GraphQLInt).build()).argument(GraphQLArgument.newArgument().name(NAME_ARGUMENT).description("Searching by looking for a string in the name or the full name").type((GraphQLInputType)Scalars.GraphQLString).build()).argument(GraphQLArgument.newArgument().name(GROUP_ARGUMENT).description("Searching by looking for a string in one of the groups the account belongs to").type((GraphQLInputType)Scalars.GraphQLString).build()).dataFetcher(this.adminAccountsFetcher()).build();
    }

    private DataFetcher adminAccountsFetcher() {
        return environment -> {
            Integer id = (Integer)environment.getArgument(ID_ARGUMENT);
            String name = (String)environment.getArgument(NAME_ARGUMENT);
            String group = (String)environment.getArgument(GROUP_ARGUMENT);
            if (id != null) {
                GraphqlUtils.checkArgList(environment, ID_ARGUMENT);
                return Collections.singletonList(this.accountService.getAccount(ID.of((int)id)));
            }
            Predicate<Account> filter2 = a -> true;
            if (StringUtils.isNotBlank((CharSequence)name)) {
                filter2 = filter2.and(account -> StringUtils.contains((CharSequence)account.getName(), (CharSequence)name) || StringUtils.contains((CharSequence)account.getFullName(), (CharSequence)name));
            }
            if (StringUtils.isNotBlank((CharSequence)group)) {
                filter2 = filter2.and(account -> account.getAccountGroups().stream().anyMatch(grp -> StringUtils.contains((CharSequence)grp.getName(), (CharSequence)group)));
            }
            return this.accountService.getAccounts().stream().filter(filter2).collect(Collectors.toList());
        };
    }
}

