/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.graphql.schema;

import graphql.Scalars;
import graphql.schema.DataFetcher;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLType;
import java.util.Collections;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.nemerosa.ontrack.graphql.schema.GQLRootQuery;
import net.nemerosa.ontrack.graphql.schema.GQLTypeAccountGroup;
import net.nemerosa.ontrack.graphql.support.GraphqlUtils;
import net.nemerosa.ontrack.model.security.AccountGroup;
import net.nemerosa.ontrack.model.security.AccountGroupMappingService;
import net.nemerosa.ontrack.model.security.AccountService;
import net.nemerosa.ontrack.model.structure.ID;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class GQLRootQueryAdminAccountGroups
implements GQLRootQuery {
    public static final String ID_ARGUMENT = "id";
    public static final String NAME_ARGUMENT = "name";
    public static final String MAPPING_ARGUMENT = "mapping";
    private final AccountService accountService;
    private final AccountGroupMappingService accountGroupMappingService;
    private final GQLTypeAccountGroup accountGroup;

    @Autowired
    public GQLRootQueryAdminAccountGroups(AccountService accountService, AccountGroupMappingService accountGroupMappingService, GQLTypeAccountGroup accountGroup) {
        this.accountService = accountService;
        this.accountGroupMappingService = accountGroupMappingService;
        this.accountGroup = accountGroup;
    }

    @Override
    public GraphQLFieldDefinition getFieldDefinition() {
        return GraphQLFieldDefinition.newFieldDefinition().name("accountGroups").type(GraphqlUtils.stdList((GraphQLType)this.accountGroup.getTypeRef())).argument(arg -> arg.name(ID_ARGUMENT).description("Searching by ID").type((GraphQLInputType)Scalars.GraphQLInt)).argument(arg -> arg.name(NAME_ARGUMENT).description("Searching by looking for a string in the name or the description").type((GraphQLInputType)Scalars.GraphQLString)).argument(arg -> arg.name(MAPPING_ARGUMENT).description("Searching by looking for a mapping").type((GraphQLInputType)Scalars.GraphQLString)).dataFetcher(this.adminAccountGroupsFetcher()).build();
    }

    private DataFetcher adminAccountGroupsFetcher() {
        return environment -> {
            Integer id = (Integer)environment.getArgument(ID_ARGUMENT);
            String name = (String)environment.getArgument(NAME_ARGUMENT);
            String mapping = (String)environment.getArgument(MAPPING_ARGUMENT);
            if (id != null) {
                GraphqlUtils.checkArgList(environment, ID_ARGUMENT);
                return Collections.singletonList(this.accountService.getAccountGroup(ID.of((int)id)));
            }
            Predicate<AccountGroup> filter2 = a -> true;
            if (StringUtils.isNotBlank((CharSequence)name)) {
                filter2 = filter2.and(group -> StringUtils.contains((CharSequence)group.getName(), (CharSequence)name) || StringUtils.contains((CharSequence)group.getDescription(), (CharSequence)name));
            }
            if (StringUtils.isNotBlank((CharSequence)mapping)) {
                filter2 = filter2.and(group -> this.accountGroupMappingService.getMappingsForGroup(group).stream().anyMatch(m -> StringUtils.equals((CharSequence)mapping, (CharSequence)m.getName())));
            }
            return this.accountService.getAccountGroups().stream().filter(filter2).collect(Collectors.toList());
        };
    }
}

