/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.graphql.schema;

import graphql.Scalars;
import graphql.schema.DataFetcher;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLType;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.nemerosa.ontrack.graphql.schema.GQLRootQuery;
import net.nemerosa.ontrack.graphql.schema.GQLTypeAccountGroupMapping;
import net.nemerosa.ontrack.graphql.support.GraphqlUtils;
import net.nemerosa.ontrack.model.security.AccountGroupMapping;
import net.nemerosa.ontrack.model.security.AccountGroupMappingService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class GQLRootQueryAdminAccountGroupMappings
implements GQLRootQuery {
    private static final String MAPPING_TYPE_ARGUMENT = "type";
    private static final String MAPPING_NAME_ARGUMENT = "name";
    private static final String MAPPING_GROUP_ARGUMENT = "group";
    private final AccountGroupMappingService accountGroupMappingService;
    private final GQLTypeAccountGroupMapping accountGroupMapping;

    @Autowired
    public GQLRootQueryAdminAccountGroupMappings(AccountGroupMappingService accountGroupMappingService, GQLTypeAccountGroupMapping accountGroupMapping) {
        this.accountGroupMappingService = accountGroupMappingService;
        this.accountGroupMapping = accountGroupMapping;
    }

    @Override
    public GraphQLFieldDefinition getFieldDefinition() {
        return GraphQLFieldDefinition.newFieldDefinition().name("accountGroupMappings").type(GraphqlUtils.stdList((GraphQLType)this.accountGroupMapping.getTypeRef())).argument(a -> a.name(MAPPING_TYPE_ARGUMENT).description("Mapping type").type((GraphQLInputType)new GraphQLNonNull((GraphQLType)Scalars.GraphQLString))).argument(a -> a.name(MAPPING_NAME_ARGUMENT).description("Mapping name").type((GraphQLInputType)Scalars.GraphQLString)).argument(a -> a.name(MAPPING_GROUP_ARGUMENT).description("Group name").type((GraphQLInputType)Scalars.GraphQLString)).dataFetcher(this.adminAccountGroupMappingsFetcher()).build();
    }

    private DataFetcher adminAccountGroupMappingsFetcher() {
        return environment -> {
            Optional<String> groupArgument;
            Predicate<AccountGroupMapping> filter2 = agm -> true;
            Optional<String> nameArgument = GraphqlUtils.getStringArgument(environment, MAPPING_NAME_ARGUMENT);
            if (nameArgument.isPresent()) {
                filter2 = filter2.and(agm -> StringUtils.equals((CharSequence)((CharSequence)nameArgument.get()), (CharSequence)agm.getName()));
            }
            if ((groupArgument = GraphqlUtils.getStringArgument(environment, MAPPING_GROUP_ARGUMENT)).isPresent()) {
                filter2 = filter2.and(agm -> StringUtils.equals((CharSequence)((CharSequence)groupArgument.get()), (CharSequence)agm.getGroup().getName()));
            }
            return this.accountGroupMappingService.getMappings(GraphqlUtils.getStringArgument(environment, MAPPING_TYPE_ARGUMENT).orElseThrow(() -> new IllegalStateException("Required argument: type"))).stream().filter(filter2).collect(Collectors.toList());
        };
    }
}

