/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.graphql.schema;

import graphql.Scalars;
import graphql.schema.DataFetcher;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLType;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.nemerosa.ontrack.graphql.schema.GQLProjectEntityFieldContributor;
import net.nemerosa.ontrack.graphql.schema.GQLTypeProperty;
import net.nemerosa.ontrack.graphql.support.GraphqlUtils;
import net.nemerosa.ontrack.model.structure.ProjectEntity;
import net.nemerosa.ontrack.model.structure.ProjectEntityType;
import net.nemerosa.ontrack.model.structure.PropertyService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class GQLProjectEntityPropertyListFieldContributor
implements GQLProjectEntityFieldContributor {
    private final PropertyService propertyService;
    private final GQLTypeProperty property;

    @Autowired
    public GQLProjectEntityPropertyListFieldContributor(PropertyService propertyService, GQLTypeProperty property) {
        this.propertyService = propertyService;
        this.property = property;
    }

    @Override
    public List<GraphQLFieldDefinition> getFields(Class<? extends ProjectEntity> projectEntityClass, ProjectEntityType projectEntityType) {
        return Collections.singletonList(GraphQLFieldDefinition.newFieldDefinition().name("properties").description("List of properties").argument(GraphQLArgument.newArgument().name("type").description("Fully qualified name of the property type").type((GraphQLInputType)Scalars.GraphQLString).build()).argument(GraphQLArgument.newArgument().name("hasValue").description("Keeps properties having a value").type((GraphQLInputType)Scalars.GraphQLBoolean).defaultValue((Object)false).build()).type(GraphqlUtils.stdList((GraphQLType)this.property.getTypeRef())).dataFetcher(this.projectEntityPropertiesDataFetcher(projectEntityClass)).build());
    }

    private DataFetcher projectEntityPropertiesDataFetcher(Class<? extends ProjectEntity> projectEntityClass) {
        return environment -> {
            Object o = environment.getSource();
            if (projectEntityClass.isInstance(o)) {
                Optional<String> typeFilter = GraphqlUtils.getStringArgument(environment, "type");
                boolean hasValue = GraphqlUtils.getBooleanArgument(environment, "hasValue", false);
                return this.propertyService.getProperties((ProjectEntity)o).stream().filter(property -> typeFilter.map(typeFilterName -> StringUtils.equals((CharSequence)typeFilterName, (CharSequence)property.getTypeDescriptor().getTypeName())).orElse(true)).filter(property -> !hasValue || !property.isEmpty()).collect(Collectors.toList());
            }
            return null;
        };
    }
}

