/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.graphql.schema;

import graphql.schema.DataFetcher;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLOutputType;
import java.util.List;
import java.util.stream.Collectors;
import net.nemerosa.ontrack.graphql.schema.GQLProjectEntityFieldContributor;
import net.nemerosa.ontrack.graphql.schema.GQLTypeProperty;
import net.nemerosa.ontrack.model.structure.ProjectEntity;
import net.nemerosa.ontrack.model.structure.ProjectEntityType;
import net.nemerosa.ontrack.model.structure.PropertyService;
import net.nemerosa.ontrack.model.structure.PropertyType;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class GQLProjectEntityPropertyFieldContributor
implements GQLProjectEntityFieldContributor {
    private final PropertyService propertyService;
    private final GQLTypeProperty property;

    @Autowired
    public GQLProjectEntityPropertyFieldContributor(PropertyService propertyService, GQLTypeProperty property) {
        this.propertyService = propertyService;
        this.property = property;
    }

    @Override
    public List<GraphQLFieldDefinition> getFields(Class<? extends ProjectEntity> projectEntityClass, ProjectEntityType projectEntityType) {
        return this.propertyService.getPropertyTypes().stream().filter(propertyType -> propertyType.getSupportedEntityTypes().contains(projectEntityType)).map(propertyType -> GraphQLFieldDefinition.newFieldDefinition().name(this.propertyFieldName((PropertyType<?>)propertyType)).description(propertyType.getDescription()).type((GraphQLOutputType)this.property.getTypeRef()).dataFetcher(this.projectEntityPropertyDataFetcher((PropertyType)propertyType, projectEntityClass)).build()).collect(Collectors.toList());
    }

    private String propertyFieldName(PropertyType<?> propertyType) {
        String baseName = StringUtils.uncapitalize((String)propertyType.getClass().getSimpleName());
        return StringUtils.substringBeforeLast((String)baseName, (String)"Type");
    }

    private <P> DataFetcher projectEntityPropertyDataFetcher(PropertyType<P> propertyType, Class<? extends ProjectEntity> projectEntityClass) {
        return environment -> {
            Object source = environment.getSource();
            if (projectEntityClass.isInstance(source)) {
                ProjectEntity projectEntity = (ProjectEntity)source;
                return this.propertyService.getProperty(projectEntity, propertyType.getClass().getName());
            }
            return null;
        };
    }
}

