/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.graphql.schema;

import graphql.Scalars;
import graphql.schema.DataFetcher;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLType;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.nemerosa.ontrack.graphql.schema.GQLProjectEntityFieldContributor;
import net.nemerosa.ontrack.graphql.schema.GQLTypeDecoration;
import net.nemerosa.ontrack.graphql.support.GraphqlUtils;
import net.nemerosa.ontrack.model.structure.DecorationService;
import net.nemerosa.ontrack.model.structure.ProjectEntity;
import net.nemerosa.ontrack.model.structure.ProjectEntityType;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class GQLProjectEntityDecorationListFieldContributor
implements GQLProjectEntityFieldContributor {
    private final DecorationService decorationService;
    private final GQLTypeDecoration decoration;

    @Autowired
    public GQLProjectEntityDecorationListFieldContributor(DecorationService decorationService, GQLTypeDecoration decoration) {
        this.decorationService = decorationService;
        this.decoration = decoration;
    }

    @Override
    public List<GraphQLFieldDefinition> getFields(Class<? extends ProjectEntity> projectEntityClass, ProjectEntityType projectEntityType) {
        return Collections.singletonList(GraphQLFieldDefinition.newFieldDefinition().name("decorations").description("List of decorations").argument(GraphQLArgument.newArgument().name("type").description("Fully qualified name of the decoration type").type((GraphQLInputType)Scalars.GraphQLString).build()).type(GraphqlUtils.stdList((GraphQLType)this.decoration.getTypeRef())).dataFetcher(this.projectEntityDecorationsDataFetcher(projectEntityClass)).build());
    }

    private DataFetcher projectEntityDecorationsDataFetcher(Class<? extends ProjectEntity> projectEntityClass) {
        return environment -> {
            Object o = environment.getSource();
            if (projectEntityClass.isInstance(o)) {
                Optional<String> typeFilter = GraphqlUtils.getStringArgument(environment, "type");
                return this.decorationService.getDecorations((ProjectEntity)o).stream().filter(property -> typeFilter.map(typeFilterName -> StringUtils.equals((CharSequence)typeFilterName, (CharSequence)property.getDecorationType())).orElse(true)).collect(Collectors.toList());
            }
            return null;
        };
    }
}

