/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.graphql.schema;

import graphql.Scalars;
import graphql.schema.DataFetcher;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLType;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.nemerosa.ontrack.graphql.schema.GQLProjectEntityFieldContributor;
import net.nemerosa.ontrack.graphql.schema.GQLTypeProjectAuthorization;
import net.nemerosa.ontrack.graphql.support.GraphqlUtils;
import net.nemerosa.ontrack.model.security.AccountService;
import net.nemerosa.ontrack.model.security.ProjectRole;
import net.nemerosa.ontrack.model.security.RolesService;
import net.nemerosa.ontrack.model.structure.Project;
import net.nemerosa.ontrack.model.structure.ProjectEntity;
import net.nemerosa.ontrack.model.structure.ProjectEntityType;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class GQLProjectAuthorizationsFieldContributor
implements GQLProjectEntityFieldContributor {
    private final AccountService accountService;
    private final RolesService rolesService;
    private final GQLTypeProjectAuthorization projectAuthorization;

    @Autowired
    public GQLProjectAuthorizationsFieldContributor(AccountService accountService, RolesService rolesService, GQLTypeProjectAuthorization projectAuthorization) {
        this.accountService = accountService;
        this.rolesService = rolesService;
        this.projectAuthorization = projectAuthorization;
    }

    @Override
    public List<GraphQLFieldDefinition> getFields(Class<? extends ProjectEntity> projectEntityClass, ProjectEntityType projectEntityType) {
        if (projectEntityType == ProjectEntityType.PROJECT) {
            return Collections.singletonList(GraphQLFieldDefinition.newFieldDefinition().name("projectRoles").description("Authorisations for the project").type(GraphqlUtils.stdList((GraphQLType)this.projectAuthorization.getTypeRef())).argument(a -> a.name("role").description("Filter by role name").type((GraphQLInputType)Scalars.GraphQLString)).dataFetcher(this.projectAuthorizationsFetcher()).build());
        }
        return Collections.emptyList();
    }

    private DataFetcher projectAuthorizationsFetcher() {
        return GraphqlUtils.fetcher(Project.class, (environment, project) -> this.rolesService.getProjectRoles().stream().filter(GraphqlUtils.getStringArgument(environment, "role").map(s -> pr -> StringUtils.equals((CharSequence)s, (CharSequence)pr.getId())).orElseGet(() -> pr -> true)).map(projectRole -> this.getProjectAuthorizations((Project)project, (ProjectRole)projectRole)).collect(Collectors.toList()));
    }

    private GQLTypeProjectAuthorization.Model getProjectAuthorizations(Project project, ProjectRole projectRole) {
        return new GQLTypeProjectAuthorization.Model(projectRole.getId(), projectRole.getName(), projectRole.getDescription(), this.accountService.findAccountGroupsByProjectRole(project, projectRole), this.accountService.findAccountsByProjectRole(project, projectRole));
    }
}

