/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.graphql.schema;

import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLTypeReference;
import java.util.function.Predicate;
import net.nemerosa.ontrack.graphql.schema.GQLInputType;
import net.nemerosa.ontrack.graphql.schema.PropertyFilter;
import net.nemerosa.ontrack.graphql.support.GraphQLBeanConverter;
import net.nemerosa.ontrack.model.structure.ProjectEntity;
import net.nemerosa.ontrack.model.structure.Property;
import net.nemerosa.ontrack.model.structure.PropertyService;
import net.nemerosa.ontrack.model.structure.PropertyType;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class GQLInputPropertyFilter
implements GQLInputType<PropertyFilter> {
    public static final String ARGUMENT_NAME = "withProperty";
    private final PropertyService propertyService;

    @Autowired
    public GQLInputPropertyFilter(PropertyService propertyService) {
        this.propertyService = propertyService;
    }

    @Override
    public GraphQLTypeReference getTypeRef() {
        return new GraphQLTypeReference(PropertyFilter.class.getSimpleName());
    }

    @Override
    public GraphQLInputType createInputType() {
        return GraphQLBeanConverter.asInputType(PropertyFilter.class);
    }

    @Override
    public PropertyFilter convert(Object argument) {
        if (argument == null) {
            return null;
        }
        return GraphQLBeanConverter.asObject(argument, PropertyFilter.class);
    }

    public GraphQLArgument asArgument() {
        return GraphQLArgument.newArgument().name(ARGUMENT_NAME).description("Filter on property type and optional value pattern.").type((GraphQLInputType)new GraphQLTypeReference(PropertyFilter.class.getSimpleName())).build();
    }

    public Predicate<? super ProjectEntity> getFilter(PropertyFilter filter2) {
        return e -> this.matchProperty((ProjectEntity)e, filter2);
    }

    private <T> boolean matchProperty(ProjectEntity e, PropertyFilter filter2) {
        PropertyType type = this.propertyService.getPropertyTypeByName(filter2.getType());
        Property property = this.propertyService.getProperty(e, filter2.getType());
        return !property.isEmpty() && (StringUtils.isBlank((CharSequence)filter2.getValue()) || type.containsValue(property.getValue(), filter2.getValue()));
    }
}

