/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.graphql.schema;

import com.fasterxml.jackson.databind.JsonNode;
import graphql.Scalars;
import graphql.schema.GraphQLInputObjectField;
import graphql.schema.GraphQLInputObjectType;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLTypeReference;
import java.util.Map;
import net.nemerosa.ontrack.graphql.schema.GQLInputType;
import net.nemerosa.ontrack.json.JsonUtils;
import net.nemerosa.ontrack.model.buildfilter.BuildFilterProviderData;
import net.nemerosa.ontrack.model.buildfilter.BuildFilterService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class GQLInputBuildStandardFilter
implements GQLInputType<BuildFilterProviderData<?>> {
    public static final String STANDARD_BUILD_FILTER = "StandardBuildFilter";
    private final BuildFilterService buildFilterService;

    @Autowired
    public GQLInputBuildStandardFilter(BuildFilterService buildFilterService) {
        this.buildFilterService = buildFilterService;
    }

    @Override
    public GraphQLTypeReference getTypeRef() {
        return new GraphQLTypeReference(STANDARD_BUILD_FILTER);
    }

    @Override
    public GraphQLInputType createInputType() {
        return GraphQLInputObjectType.newInputObject().name(STANDARD_BUILD_FILTER).field(GraphQLInputObjectField.newInputObjectField().name("count").description("Maximum number of builds to display").type((GraphQLInputType)Scalars.GraphQLInt).defaultValue((Object)10).build()).field(this.formField("sincePromotionLevel", "Builds since the last one which was promoted to this level")).field(this.formField("withPromotionLevel", "Builds with this promotion level")).field(this.formField("afterDate", "Build created after or on this date")).field(this.formField("beforeDate", "Build created before or on this date")).field(this.formField("sinceValidationStamp", "Builds since the last one which had this validation stamp")).field(this.formField("sinceValidationStampStatus", "... with status")).field(this.formField("withValidationStamp", "Builds with this validation stamp")).field(this.formField("withValidationStampStatus", "... with status")).field(this.formField("withProperty", "With property")).field(this.formField("withPropertyValue", "...with value")).field(this.formField("sinceProperty", "Since property")).field(this.formField("sincePropertyValue", "...with value")).field(this.formField("linkedFrom", "The build must be linked FROM the builds selected by the pattern.\nSyntax: PRJ:BLD where PRJ is a project name and BLD a build expression - with * as placeholder")).field(this.formField("linkedFromPromotion", "The build must be linked FROM a build having this promotion (requires \"linkedFrom\")")).field(this.formField("linkedTo", "The build must be linked TO the builds selected by the pattern.\nSyntax: PRJ:BLD where PRJ is a project name and BLD a build expression - with * as placeholder")).field(this.formField("linkedToPromotion", "The build must be linked TO a build having this promotion (requires \"linkedTo\")")).build();
    }

    @Override
    public BuildFilterProviderData<?> convert(Object filter2) {
        if (filter2 == null) {
            return this.buildFilterService.standardFilterProviderData(10).build();
        }
        if (!(filter2 instanceof Map)) {
            throw new IllegalStateException("Filter is expected to be a map");
        }
        Map map = (Map)filter2;
        JsonNode node = JsonUtils.fromMap((Map)map);
        return this.buildFilterService.standardFilterProviderData(node);
    }

    @Override
    private GraphQLInputObjectField formField(String fieldName, String description) {
        return GraphQLInputObjectField.newInputObjectField().name(fieldName).description(description).type((GraphQLInputType)Scalars.GraphQLString).build();
    }
}

