/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.graphql.schema;

import graphql.schema.DataFetcher;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLOutputType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import net.nemerosa.ontrack.graphql.schema.GQLProjectEntityFieldContributor;
import net.nemerosa.ontrack.graphql.schema.GQLType;
import net.nemerosa.ontrack.graphql.schema.GQLTypeCreation;
import net.nemerosa.ontrack.graphql.support.GraphqlUtils;
import net.nemerosa.ontrack.model.structure.ProjectEntity;
import net.nemerosa.ontrack.model.structure.ProjectEntityType;
import net.nemerosa.ontrack.model.structure.Signature;

public abstract class AbstractGQLProjectEntity<T extends ProjectEntity>
implements GQLType {
    private final Class<T> projectEntityClass;
    private final ProjectEntityType projectEntityType;
    private final List<GQLProjectEntityFieldContributor> projectEntityFieldContributors;
    private final GQLTypeCreation creation;

    public AbstractGQLProjectEntity(Class<T> projectEntityClass, ProjectEntityType projectEntityType, List<GQLProjectEntityFieldContributor> projectEntityFieldContributors, GQLTypeCreation creation) {
        this.projectEntityClass = projectEntityClass;
        this.projectEntityType = projectEntityType;
        this.projectEntityFieldContributors = projectEntityFieldContributors;
        this.creation = creation;
    }

    protected List<GraphQLFieldDefinition> projectEntityInterfaceFields() {
        List<GraphQLFieldDefinition> definitions = this.baseProjectEntityInterfaceFields();
        definitions.addAll(this.projectEntityFieldContributors.stream().map(contributor -> contributor.getFields(this.projectEntityClass, this.projectEntityType)).filter(Objects::nonNull).flatMap(Collection::stream).collect(Collectors.toList()));
        return definitions;
    }

    private List<GraphQLFieldDefinition> baseProjectEntityInterfaceFields() {
        return new ArrayList<GraphQLFieldDefinition>(Arrays.asList(GraphqlUtils.idField(), GraphqlUtils.nameField(), GraphqlUtils.descriptionField(), GraphQLFieldDefinition.newFieldDefinition().name("creation").type((GraphQLOutputType)this.creation.getTypeRef()).dataFetcher(this.creationFetcher()).build()));
    }

    protected DataFetcher creationFetcher() {
        return GraphqlUtils.fetcher(this.projectEntityClass, entity -> this.getSignature(entity).map(GQLTypeCreation::getCreationFromSignature).orElse(null));
    }

    protected abstract Optional<Signature> getSignature(T var1);
}

