/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.graphql;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import graphql.ExecutionResult;
import graphql.schema.GraphQLSchema;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.Callable;
import net.nemerosa.ontrack.graphql.schema.GraphqlSchemaService;
import net.nemerosa.ontrack.graphql.service.GraphQLService;
import net.nemerosa.ontrack.json.ObjectMapperFactory;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Transactional
@RestController
@RequestMapping(value={"/graphql"})
public class GraphqlController {
    private final GraphqlSchemaService schemaService;
    private final GraphQLService graphQLService;
    private final ObjectMapper objectMapper = ObjectMapperFactory.create();

    @Autowired
    public GraphqlController(GraphqlSchemaService schemaService, GraphQLService graphQLService) {
        this.schemaService = schemaService;
        this.graphQLService = graphQLService;
    }

    @RequestMapping(method={RequestMethod.GET})
    @Transactional
    public Callable<ResponseEntity<JsonNode>> get(@RequestParam String query, @RequestParam(required=false) String variables, @RequestParam(required=false) String operationName) throws IOException {
        return () -> {
            Map<String, Object> arguments = this.decodeIntoMap(variables);
            return ResponseEntity.ok((Object)this.requestAsJson(new Request(query, arguments, operationName)));
        };
    }

    @RequestMapping(method={RequestMethod.POST})
    @Transactional
    public Callable<ResponseEntity<JsonNode>> post(@RequestBody String input) throws IOException {
        return () -> {
            Request request = (Request)this.objectMapper.readValue(input, Request.class);
            request = request.withVariables();
            return ResponseEntity.ok((Object)this.requestAsJson(request));
        };
    }

    public JsonNode requestAsJson(Request request) {
        return this.objectMapper.valueToTree((Object)this.request(request));
    }

    public ExecutionResult request(Request request) {
        GraphQLSchema schema = this.schemaService.getSchema();
        return this.graphQLService.execute(schema, request.getQuery(), request.getVariables(), request.getOperationName(), true);
    }

    private Map<String, Object> decodeIntoMap(String variablesParam) throws IOException {
        if (StringUtils.isNotBlank((CharSequence)variablesParam)) {
            return (Map)this.objectMapper.readValue(variablesParam, Map.class);
        }
        return Collections.emptyMap();
    }

    public static class Request {
        private final String query;
        private final Map<String, Object> variables;
        private final String operationName;

        public Request withVariables() {
            if (this.variables == null) {
                return this.withVariables(Collections.emptyMap());
            }
            return this;
        }

        @ConstructorProperties(value={"query", "variables", "operationName"})
        public Request(String query, Map<String, Object> variables, String operationName) {
            this.query = query;
            this.variables = variables;
            this.operationName = operationName;
        }

        public String getQuery() {
            return this.query;
        }

        public Map<String, Object> getVariables() {
            return this.variables;
        }

        public String getOperationName() {
            return this.operationName;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Request)) {
                return false;
            }
            Request other = (Request)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$query = this.getQuery();
            String other$query = other.getQuery();
            if (this$query == null ? other$query != null : !this$query.equals(other$query)) {
                return false;
            }
            Map<String, Object> this$variables = this.getVariables();
            Map<String, Object> other$variables = other.getVariables();
            if (this$variables == null ? other$variables != null : !((Object)this$variables).equals(other$variables)) {
                return false;
            }
            String this$operationName = this.getOperationName();
            String other$operationName = other.getOperationName();
            return !(this$operationName == null ? other$operationName != null : !this$operationName.equals(other$operationName));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Request;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $query = this.getQuery();
            result = result * 59 + ($query == null ? 43 : $query.hashCode());
            Map<String, Object> $variables = this.getVariables();
            result = result * 59 + ($variables == null ? 43 : ((Object)$variables).hashCode());
            String $operationName = this.getOperationName();
            result = result * 59 + ($operationName == null ? 43 : $operationName.hashCode());
            return result;
        }

        public String toString() {
            return "GraphqlController.Request(query=" + this.getQuery() + ", variables=" + this.getVariables() + ", operationName=" + this.getOperationName() + ")";
        }

        public Request withVariables(Map<String, Object> variables) {
            return this.variables == variables ? this : new Request(this.query, variables, this.operationName);
        }
    }
}

