/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.tx;

import java.util.Map;
import java.util.Stack;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import net.nemerosa.ontrack.tx.Transaction;
import net.nemerosa.ontrack.tx.TransactionResource;
import net.nemerosa.ontrack.tx.TransactionResourceProvider;
import net.nemerosa.ontrack.tx.TransactionService;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0017\u0018\u00002\u00020\u0001:\u0003\r\u000e\u000fB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0007\u001a\u00020\u0006H\u0012J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u001a\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0004X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lnet/nemerosa/ontrack/tx/DefaultTransactionService;", "Lnet/nemerosa/ontrack/tx/TransactionService;", "()V", "transaction", "Ljava/lang/ThreadLocal;", "Ljava/util/Stack;", "Lnet/nemerosa/ontrack/tx/DefaultTransactionService$ITransaction;", "createTransaction", "get", "Lnet/nemerosa/ontrack/tx/Transaction;", "start", "nested", "", "ITransaction", "TransactionCallback", "TransactionImpl", "ontrack-tx"})
public class DefaultTransactionService
implements TransactionService {
    private final ThreadLocal<Stack<ITransaction>> transaction = new ThreadLocal();

    @Override
    @NotNull
    public Transaction start() {
        return this.start(false);
    }

    @Override
    @NotNull
    public Transaction start(boolean nested) {
        Stack<ITransaction> currents = this.transaction.get();
        if (currents == null || currents.isEmpty()) {
            ITransaction current = this.createTransaction();
            currents = new Stack();
            currents.push(current);
            this.transaction.set(currents);
            return current;
        }
        if (nested) {
            ITransaction current = this.createTransaction();
            currents.push(current);
            return current;
        }
        currents.peek().reuse();
        ITransaction iTransaction = currents.peek();
        Intrinsics.checkExpressionValueIsNotNull((Object)iTransaction, (String)"currents.peek()");
        return iTransaction;
    }

    @Override
    @NotNull
    public Transaction get() {
        Stack<ITransaction> stack;
        Stack<ITransaction> stack2 = stack = this.transaction.get();
        ITransaction iTransaction = stack2 != null ? stack2.peek() : null;
        if (iTransaction == null) {
            throw new TypeCastException("null cannot be cast to non-null type net.nemerosa.ontrack.tx.Transaction");
        }
        return iTransaction;
    }

    private ITransaction createTransaction() {
        return new TransactionImpl(new TransactionCallback(this){
            final /* synthetic */ DefaultTransactionService this$0;

            public void remove(@NotNull ITransaction tx) {
                Intrinsics.checkParameterIsNotNull((Object)tx, (String)"tx");
                Stack stack = (Stack)DefaultTransactionService.access$getTransaction$p(this.this$0).get();
                stack.pop();
                if (stack.isEmpty()) {
                    DefaultTransactionService.access$getTransaction$p(this.this$0).set(null);
                }
            }
            {
                this.this$0 = $outer;
            }
        });
    }

    @Override
    public <T> T doInTransaction(@NotNull Function0<? extends T> task) {
        Intrinsics.checkParameterIsNotNull(task, (String)"task");
        return TransactionService.DefaultImpls.doInTransaction(this, task);
    }

    public static final /* synthetic */ ThreadLocal access$getTransaction$p(DefaultTransactionService $this) {
        return $this.transaction;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\bb\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&\u00a8\u0006\u0004"}, d2={"Lnet/nemerosa/ontrack/tx/DefaultTransactionService$ITransaction;", "Lnet/nemerosa/ontrack/tx/Transaction;", "reuse", "", "ontrack-tx"})
    private static interface ITransaction
    extends Transaction {
        public void reuse();
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bb\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006"}, d2={"Lnet/nemerosa/ontrack/tx/DefaultTransactionService$TransactionCallback;", "", "remove", "", "tx", "Lnet/nemerosa/ontrack/tx/DefaultTransactionService$ITransaction;", "ontrack-tx"})
    private static interface TransactionCallback {
        public void remove(@NotNull ITransaction var1);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\r\u001a\u00020\u000eH\u0016J;\u0010\u000f\u001a\u0002H\u0010\"\b\b\u0000\u0010\u0010*\u00020\u000b2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\u00100\n2\u0006\u0010\u0012\u001a\u00020\f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\u00100\u0014H\u0016\u00a2\u0006\u0002\u0010\u0015J\b\u0010\u0016\u001a\u00020\u000eH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R.\u0010\u0007\u001a\"\u0012\u0018\u0012\u0016\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\n\u0012\u0004\u0012\u00020\f0\t\u0012\u0004\u0012\u00020\u000b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lnet/nemerosa/ontrack/tx/DefaultTransactionService$TransactionImpl;", "Lnet/nemerosa/ontrack/tx/DefaultTransactionService$ITransaction;", "transactionCallback", "Lnet/nemerosa/ontrack/tx/DefaultTransactionService$TransactionCallback;", "(Lnet/nemerosa/ontrack/tx/DefaultTransactionService$TransactionCallback;)V", "count", "Ljava/util/concurrent/atomic/AtomicInteger;", "resources", "Ljava/util/concurrent/ConcurrentMap;", "Lkotlin/Pair;", "Ljava/lang/Class;", "Lnet/nemerosa/ontrack/tx/TransactionResource;", "", "close", "", "getResource", "T", "resourceType", "resourceId", "provider", "Lnet/nemerosa/ontrack/tx/TransactionResourceProvider;", "(Ljava/lang/Class;Ljava/lang/Object;Lnet/nemerosa/ontrack/tx/TransactionResourceProvider;)Lnet/nemerosa/ontrack/tx/TransactionResource;", "reuse", "ontrack-tx"})
    private static final class TransactionImpl
    implements ITransaction {
        private final AtomicInteger count;
        private final ConcurrentMap<Pair<Class<? extends TransactionResource>, Object>, TransactionResource> resources;
        private final TransactionCallback transactionCallback;

        @Override
        public void close() {
            int value = this.count.decrementAndGet();
            if (value == 0) {
                this.transactionCallback.remove(this);
                for (TransactionResource resource : this.resources.values()) {
                    resource.close();
                }
            }
        }

        @Override
        @NotNull
        public synchronized <T extends TransactionResource> T getResource(@NotNull Class<T> resourceType, @NotNull Object resourceId, @NotNull TransactionResourceProvider<T> provider) {
            Intrinsics.checkParameterIsNotNull(resourceType, (String)"resourceType");
            Intrinsics.checkParameterIsNotNull((Object)resourceId, (String)"resourceId");
            Intrinsics.checkParameterIsNotNull(provider, (String)"provider");
            TransactionResource resource = (TransactionResource)this.resources.get(TuplesKt.to(resourceType, (Object)resourceId));
            if (resource == null) {
                resource = provider.createTxResource();
                ((Map)this.resources).put(TuplesKt.to(resourceType, (Object)resource), resource);
            }
            return (T)resource;
        }

        @Override
        public void reuse() {
            this.count.incrementAndGet();
        }

        public TransactionImpl(@NotNull TransactionCallback transactionCallback) {
            Intrinsics.checkParameterIsNotNull((Object)transactionCallback, (String)"transactionCallback");
            this.transactionCallback = transactionCallback;
            this.count = new AtomicInteger(1);
            this.resources = new ConcurrentHashMap();
        }
    }
}

