/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.tx;

import com.google.common.collect.Table;
import com.google.common.collect.Tables;
import java.util.Stack;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import net.nemerosa.ontrack.tx.Transaction;
import net.nemerosa.ontrack.tx.TransactionResource;
import net.nemerosa.ontrack.tx.TransactionResourceProvider;
import net.nemerosa.ontrack.tx.TransactionService;
import org.springframework.stereotype.Service;

@Service
public class DefaultTransactionService
implements TransactionService {
    private final ThreadLocal<Stack<ITransaction>> transaction = new ThreadLocal();

    @Override
    public Transaction start() {
        return this.start(false);
    }

    @Override
    public Transaction start(boolean nested) {
        Stack<ITransaction> currents = this.transaction.get();
        if (currents == null || currents.isEmpty()) {
            ITransaction current = this.createTransaction();
            currents = new Stack();
            currents.push(current);
            this.transaction.set(currents);
            return current;
        }
        if (nested) {
            ITransaction current = this.createTransaction();
            currents.push(current);
            return current;
        }
        currents.peek().reuse();
        return currents.peek();
    }

    @Override
    public Transaction get() {
        Stack<ITransaction> stack = this.transaction.get();
        if (stack != null) {
            return stack.peek();
        }
        return null;
    }

    protected ITransaction createTransaction() {
        return new TransactionImpl(tx -> {
            Stack<ITransaction> stack = this.transaction.get();
            stack.pop();
            if (stack.isEmpty()) {
                this.transaction.set(null);
            }
        });
    }

    private static class TransactionImpl
    implements ITransaction {
        private final TransactionCallback transactionCallback;
        private final AtomicInteger count = new AtomicInteger(1);
        private final Table<Class<? extends TransactionResource>, Object, TransactionResource> resources = Tables.newCustomTable(new ConcurrentHashMap(), ConcurrentHashMap::new);

        public TransactionImpl(TransactionCallback transactionCallback) {
            this.transactionCallback = transactionCallback;
        }

        @Override
        public void close() {
            int value = this.count.decrementAndGet();
            if (value == 0) {
                this.transactionCallback.remove(this);
                for (TransactionResource resource : this.resources.values()) {
                    resource.close();
                }
            }
        }

        @Override
        public synchronized <T extends TransactionResource> T getResource(Class<T> resourceType, Object resourceId, TransactionResourceProvider<T> provider) {
            TransactionResource resource = (TransactionResource)this.resources.get(resourceType, resourceId);
            if (resource == null) {
                resource = provider.createTxResource();
                this.resources.put(resourceType, resourceId, (Object)resource);
            }
            return (T)resource;
        }

        @Override
        public void reuse() {
            this.count.incrementAndGet();
        }
    }

    private static interface TransactionCallback {
        public void remove(ITransaction var1);
    }

    private static interface ITransaction
    extends Transaction {
        public void reuse();
    }
}

