/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.test;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.concurrent.atomic.AtomicLong;
import net.nemerosa.ontrack.json.ObjectMapperFactory;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.junit.Assert;

public final class TestUtils {
    private static final ObjectMapper mapper = ObjectMapperFactory.create();
    private static final AtomicLong counter = new AtomicLong();

    private TestUtils() {
    }

    public static String uid(String prefix) {
        return prefix + new SimpleDateFormat("mmssSSS").format(new Date()) + counter.incrementAndGet();
    }

    public static String getEnvIfPresent(String systemProperty, String envProperty, String defaulValue) {
        String value = System.getProperty(systemProperty);
        if (StringUtils.isNotBlank((CharSequence)value)) {
            return value;
        }
        value = System.getenv(envProperty);
        if (StringUtils.isNotBlank((CharSequence)value)) {
            return value;
        }
        return defaulValue;
    }

    public static String getEnv(String systemProperty, String envProperty, String name) {
        String value = TestUtils.getEnvIfPresent(systemProperty, envProperty, null);
        if (StringUtils.isBlank((CharSequence)value)) {
            throw new IllegalStateException(String.format("The %s value must be defined with the system property `%s` or the environment variable `%s`.", name, systemProperty, envProperty));
        }
        return value;
    }

    public static void assertJsonWrite(JsonNode expectedJson, Object objectToWrite) throws JsonProcessingException {
        Assert.assertEquals((Object)mapper.writeValueAsString((Object)expectedJson), (Object)mapper.writeValueAsString(objectToWrite));
    }

    public static void assertJsonWrite(JsonNode expectedJson, Object objectToWrite, Class<?> viewClass) throws JsonProcessingException {
        TestUtils.assertJsonWrite(mapper, expectedJson, objectToWrite, viewClass);
    }

    public static void assertJsonWrite(ObjectMapper mapper, JsonNode expectedJson, Object objectToWrite, Class<?> viewClass) throws JsonProcessingException {
        Assert.assertEquals((Object)mapper.writeValueAsString((Object)expectedJson), (Object)mapper.writerWithView(viewClass).writeValueAsString(objectToWrite));
    }

    public static <T> void assertJsonRead(T expectedResult, JsonNode jsonToRead, Class<T> type) throws JsonProcessingException {
        Assert.assertEquals(expectedResult, (Object)mapper.treeToValue((TreeNode)jsonToRead, type));
    }

    public static void assertJsonEquals(TreeNode o1, TreeNode o2) throws JsonProcessingException {
        Assert.assertEquals((Object)mapper.writeValueAsString((Object)o1), (Object)mapper.writeValueAsString((Object)o2));
    }

    public static LocalDateTime dateTime() {
        return LocalDateTime.of(2014, 5, 13, 20, 11);
    }

    public static String dateTimeJson() {
        return "2014-05-13T20:11:00Z";
    }

    public static byte[] resourceBytes(String path) throws IOException {
        return IOUtils.toByteArray((URL)TestUtils.class.getResource(path));
    }

    public static JsonNode resourceJson(String path) throws IOException {
        return mapper.readTree(TestUtils.resourceBytes(path));
    }

    public static int getAvailablePort() throws IOException {
        try (ServerSocket serverSocket = new ServerSocket(0);){
            int n = serverSocket.getLocalPort();
            return n;
        }
    }
}

