/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.repository;

import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import net.nemerosa.ontrack.common.Document;
import net.nemerosa.ontrack.model.Ack;
import net.nemerosa.ontrack.model.structure.Branch;
import net.nemerosa.ontrack.model.structure.Build;
import net.nemerosa.ontrack.model.structure.BuildSortDirection;
import net.nemerosa.ontrack.model.structure.ID;
import net.nemerosa.ontrack.model.structure.Project;
import net.nemerosa.ontrack.model.structure.PromotionLevel;
import net.nemerosa.ontrack.model.structure.PromotionRun;
import net.nemerosa.ontrack.model.structure.Reordering;
import net.nemerosa.ontrack.model.structure.ValidationRun;
import net.nemerosa.ontrack.model.structure.ValidationRunStatus;
import net.nemerosa.ontrack.model.structure.ValidationRunStatusID;
import net.nemerosa.ontrack.model.structure.ValidationStamp;

public interface StructureRepository {
    public Project newProject(Project var1);

    public List<Project> getProjectList();

    public Project getProject(ID var1);

    public Optional<Project> getProjectByName(String var1);

    public void saveProject(Project var1);

    public Ack deleteProject(ID var1);

    public Branch getBranch(ID var1);

    public Optional<Branch> getBranchByName(String var1, String var2);

    public List<Branch> getBranchesForProject(ID var1);

    public Branch newBranch(Branch var1);

    public void saveBranch(Branch var1);

    public Ack deleteBranch(ID var1);

    public Build newBuild(Build var1);

    public Build saveBuild(Build var1);

    public Build getBuild(ID var1);

    public Optional<Build> getBuildByName(String var1, String var2, String var3);

    public Optional<Build> findBuildAfterUsingNumericForm(ID var1, String var2);

    public int getBuildCount(Branch var1);

    public Optional<Build> getPreviousBuild(Build var1);

    public Optional<Build> getNextBuild(Build var1);

    default public void builds(Branch branch, Predicate<Build> buildPredicate) {
        this.builds(branch, buildPredicate, BuildSortDirection.FROM_NEWEST);
    }

    public void builds(Branch var1, Predicate<Build> var2, BuildSortDirection var3);

    public void builds(Project var1, Predicate<Build> var2);

    public Build getLastBuildForBranch(Branch var1);

    public Ack deleteBuild(ID var1);

    public void addBuildLink(ID var1, ID var2);

    public void deleteBuildLink(ID var1, ID var2);

    public List<Build> getBuildLinksFrom(ID var1);

    public List<Build> getBuildLinksTo(ID var1);

    public List<Build> searchBuildsLinkedTo(String var1, String var2);

    public boolean isLinkedFrom(ID var1, String var2, String var3);

    public boolean isLinkedTo(ID var1, String var2, String var3);

    public List<PromotionLevel> getPromotionLevelListForBranch(ID var1);

    public PromotionLevel newPromotionLevel(PromotionLevel var1);

    public PromotionLevel getPromotionLevel(ID var1);

    public Optional<PromotionLevel> getPromotionLevelByName(String var1, String var2, String var3);

    public Document getPromotionLevelImage(ID var1);

    public void setPromotionLevelImage(ID var1, Document var2);

    public void savePromotionLevel(PromotionLevel var1);

    public Ack deletePromotionLevel(ID var1);

    public void reorderPromotionLevels(ID var1, Reordering var2);

    public PromotionRun newPromotionRun(PromotionRun var1);

    public PromotionRun getPromotionRun(ID var1);

    public Ack deletePromotionRun(ID var1);

    public List<PromotionRun> getPromotionRunsForBuild(Build var1);

    public List<PromotionRun> getLastPromotionRunsForBuild(Build var1);

    public PromotionRun getLastPromotionRunForPromotionLevel(PromotionLevel var1);

    public Optional<PromotionRun> getLastPromotionRun(Build var1, PromotionLevel var2);

    public List<PromotionRun> getPromotionRunsForBuildAndPromotionLevel(Build var1, PromotionLevel var2);

    public List<PromotionRun> getPromotionRunsForPromotionLevel(PromotionLevel var1);

    public Optional<PromotionRun> getEarliestPromotionRunAfterBuild(PromotionLevel var1, Build var2);

    public List<ValidationStamp> getValidationStampListForBranch(ID var1);

    public ValidationStamp newValidationStamp(ValidationStamp var1);

    public ValidationStamp getValidationStamp(ID var1);

    public Optional<ValidationStamp> getValidationStampByName(String var1, String var2, String var3);

    public Document getValidationStampImage(ID var1);

    public void setValidationStampImage(ID var1, Document var2);

    public void saveValidationStamp(ValidationStamp var1);

    public Ack deleteValidationStamp(ID var1);

    public void reorderValidationStamps(ID var1, Reordering var2);

    public ValidationRun newValidationRun(ValidationRun var1, Function<String, ValidationRunStatusID> var2);

    public ValidationRun getValidationRun(ID var1, Function<String, ValidationRunStatusID> var2);

    public List<ValidationRun> getValidationRunsForBuild(Build var1, Function<String, ValidationRunStatusID> var2);

    public List<ValidationRun> getValidationRunsForBuildAndValidationStamp(Build var1, ValidationStamp var2, Function<String, ValidationRunStatusID> var3);

    public List<ValidationRun> getValidationRunsForValidationStamp(ValidationStamp var1, int var2, int var3, Function<String, ValidationRunStatusID> var4);

    public ValidationRun newValidationRunStatus(ValidationRun var1, ValidationRunStatus var2);
}

