-- v0
-- Initial schema

CREATE TABLE ONTRACK_VERSION (
  VALUE   INTEGER   NOT NULL,
  UPDATED TIMESTAMP NOT NULL
);

CREATE TABLE ACCOUNTS (
  ID       INTEGER      NOT NULL AUTO_INCREMENT,
  NAME     VARCHAR(40)  NOT NULL,
  FULLNAME VARCHAR(100) NOT NULL,
  EMAIL    VARCHAR(200) NOT NULL,
  MODE     VARCHAR(20)  NOT NULL,
  PASSWORD VARCHAR(80)  NULL,
  ROLE     VARCHAR(16)  NOT NULL,
  CONSTRAINT ACCOUNTS_PK PRIMARY KEY (ID),
  CONSTRAINT ACCOUNTS_UQ_NAME UNIQUE (NAME)
);

INSERT INTO ACCOUNTS (NAME, FULLNAME, EMAIL, MODE, PASSWORD, ROLE)
VALUES ('admin', 'Administrator', '', 'password', '$2a$10$5sx1EUYgOCWAyePfbMKaBeYz4E/CiHEzAkRuxSuCUtYCB4.vKVMpy',
        'ADMINISTRATOR');

CREATE TABLE GLOBAL_AUTHORIZATIONS (
  ACCOUNT INTEGER      NOT NULL,
  FN      VARCHAR(200) NOT NULL,
  CONSTRAINT GLOBAL_AUTHORIZATIONS_PK PRIMARY KEY (ACCOUNT, FN),
  CONSTRAINT GLOBAL_AUTHORIZATIONS_FK_ACCOUNT FOREIGN KEY (ACCOUNT) REFERENCES ACCOUNTS (ID)
    ON DELETE CASCADE
);

CREATE TABLE PROJECTS (
  ID          INTEGER      NOT NULL AUTO_INCREMENT,
  NAME        VARCHAR(40)  NOT NULL,
  DESCRIPTION VARCHAR(500) NOT NULL,
  CONSTRAINT PROJECTS_PK PRIMARY KEY (ID),
  CONSTRAINT PROJECTS_UQ UNIQUE (NAME)
);

CREATE TABLE PROJECT_AUTHORIZATIONS (
  ACCOUNT INTEGER      NOT NULL,
  PROJECT INTEGER      NOT NULL,
  FN      VARCHAR(200) NOT NULL,
  CONSTRAINT PROJECT_AUTHORIZATIONS_PK PRIMARY KEY (ACCOUNT, PROJECT, FN),
  CONSTRAINT PROJECT_AUTHORIZATIONS_FK_ACCOUNT FOREIGN KEY (ACCOUNT) REFERENCES ACCOUNTS (ID)
    ON DELETE CASCADE,
  CONSTRAINT PROJECT_AUTHORIZATIONS_FK_PROJECT FOREIGN KEY (PROJECT) REFERENCES PROJECTS (ID)
    ON DELETE CASCADE
);

CREATE TABLE BRANCHES (
  ID          INTEGER      NOT NULL AUTO_INCREMENT,
  PROJECTID   INTEGER      NOT NULL,
  NAME        VARCHAR(40)  NOT NULL,
  DESCRIPTION VARCHAR(500) NOT NULL,
  CONSTRAINT BRANCHES_PK PRIMARY KEY (ID),
  CONSTRAINT BRANCHES_UQ UNIQUE (PROJECTID, NAME),
  CONSTRAINT BRANCHES_FK_PROJECTS FOREIGN KEY (PROJECTID) REFERENCES PROJECTS (ID)
    ON DELETE CASCADE
);

CREATE TABLE BUILD_FILTERS (
  ACCOUNTID INTEGER      NOT NULL,
  BRANCHID  INTEGER      NOT NULL,
  NAME      VARCHAR(120) NOT NULL,
  TYPE      VARCHAR(150) NOT NULL,
  DATA      TEXT         NOT NULL,
  CONSTRAINT BUILD_FILTERS_PK PRIMARY KEY (ACCOUNTID, BRANCHID, NAME),
  CONSTRAINT BUILD_FILTERS_FK_ACCOUNT FOREIGN KEY (ACCOUNTID) REFERENCES ACCOUNTS (ID)
    ON DELETE CASCADE,
  CONSTRAINT BUILD_FILTERS_FK_BRANCH FOREIGN KEY (BRANCHID) REFERENCES BRANCHES (ID)
    ON DELETE CASCADE
);

CREATE TABLE BUILDS (
  ID          INTEGER      NOT NULL AUTO_INCREMENT,
  BRANCHID    INTEGER      NOT NULL,
  NAME        VARCHAR(40)  NOT NULL,
  DESCRIPTION VARCHAR(500) NOT NULL,
  CREATION    VARCHAR(24)  NOT NULL,
  CREATOR     VARCHAR(40)  NOT NULL,
  CONSTRAINT BUILDS_PK PRIMARY KEY (ID),
  CONSTRAINT BUILDS_UQ UNIQUE (BRANCHID, NAME),
  CONSTRAINT BUILDS_FK_BRANCH FOREIGN KEY (BRANCHID) REFERENCES BRANCHES (ID)
    ON DELETE CASCADE
);

CREATE TABLE PROMOTION_LEVELS (
  ID          INTEGER      NOT NULL AUTO_INCREMENT,
  BRANCHID    INTEGER      NOT NULL,
  ORDERNB     INTEGER      NOT NULL,
  NAME        VARCHAR(40)  NOT NULL,
  DESCRIPTION VARCHAR(500) NOT NULL,
  IMAGETYPE   VARCHAR(40)  NULL,
  IMAGEBYTES  BLOB         NULL,
  CONSTRAINT PROMOTION_LEVELS_PK PRIMARY KEY (ID),
  CONSTRAINT PROMOTION_LEVELS_UQ UNIQUE (BRANCHID, NAME),
  CONSTRAINT PROMOTION_LEVELS_FK_BRANCH FOREIGN KEY (BRANCHID) REFERENCES BRANCHES (ID)
    ON DELETE CASCADE
);

CREATE TABLE PROMOTION_RUNS (
  ID               INTEGER      NOT NULL AUTO_INCREMENT,
  BUILDID          INTEGER      NOT NULL,
  PROMOTIONLEVELID INTEGER      NOT NULL,
  CREATION         VARCHAR(24)  NOT NULL,
  CREATOR          VARCHAR(40)  NOT NULL,
  DESCRIPTION      VARCHAR(500) NOT NULL,
  CONSTRAINT PROMOTIONS_RUNS_PK PRIMARY KEY (ID),
  CONSTRAINT PROMOTIONS_RUNS_FK_BUILD FOREIGN KEY (BUILDID) REFERENCES BUILDS (ID)
    ON DELETE CASCADE,
  CONSTRAINT PROMOTIONS_RUNS_FK_PROMOTION_LEVEL FOREIGN KEY (PROMOTIONLEVELID) REFERENCES PROMOTION_LEVELS (ID)
    ON DELETE CASCADE
);

CREATE TABLE VALIDATION_STAMPS (
  ID              INTEGER      NOT NULL AUTO_INCREMENT,
  BRANCHID        INTEGER      NOT NULL,
  ORDERNB         INTEGER      NOT NULL,
  NAME            VARCHAR(40)  NOT NULL,
  OWNER           INTEGER      NULL,
  PROMOTION_LEVEL INTEGER      NULL,
  DESCRIPTION     VARCHAR(500) NOT NULL,
  IMAGETYPE       VARCHAR(40)  NULL,
  IMAGEBYTES      BLOB         NULL,
  CONSTRAINT VALIDATION_STAMPS_PK PRIMARY KEY (ID),
  CONSTRAINT VALIDATION_STAMPS_UQ UNIQUE (BRANCHID, NAME),
  CONSTRAINT VALIDATION_STAMPS_FK_BRANCH FOREIGN KEY (BRANCHID) REFERENCES BRANCHES (ID)
    ON DELETE CASCADE,
  CONSTRAINT VALIDATION_STAMPS_FK_OWNER FOREIGN KEY (OWNER) REFERENCES ACCOUNTS (ID)
    ON DELETE SET NULL,
  CONSTRAINT VALIDATION_STAMPS_FK_PROMOTION_LEVEL FOREIGN KEY (PROMOTION_LEVEL) REFERENCES PROMOTION_LEVELS (ID)
    ON DELETE SET NULL
);

CREATE TABLE VALIDATION_RUNS (
  ID                INTEGER NOT NULL AUTO_INCREMENT,
  BUILDID           INTEGER NOT NULL,
  VALIDATIONSTAMPID INTEGER NOT NULL,
  CONSTRAINT VALIDATION_RUNS_PK PRIMARY KEY (ID),
  CONSTRAINT VALIDATION_RUNS_FK_BUILD FOREIGN KEY (BUILDID) REFERENCES BUILDS (ID)
    ON DELETE CASCADE,
  CONSTRAINT VALIDATION_RUNS_FK_VALIDATION_STAMP FOREIGN KEY (VALIDATIONSTAMPID) REFERENCES VALIDATION_STAMPS (ID)
    ON DELETE CASCADE
);

CREATE TABLE VALIDATION_RUN_STATUSES (
  ID                    INTEGER      NOT NULL AUTO_INCREMENT,
  VALIDATIONRUNID       INTEGER      NOT NULL,
  VALIDATIONRUNSTATUSID VARCHAR(40)  NOT NULL,
  CREATION              VARCHAR(24)  NOT NULL,
  CREATOR               VARCHAR(40)  NOT NULL,
  DESCRIPTION           VARCHAR(500) NOT NULL,
  CONSTRAINT VALIDATION_RUN_STATUSES_PK PRIMARY KEY (ID),
  CONSTRAINT VALIDATION_RUN_STATUSES_FK_VALIDATIONRUNID FOREIGN KEY (VALIDATIONRUNID) REFERENCES VALIDATION_RUNS (ID)
    ON DELETE CASCADE
);

CREATE TABLE CONFIGURATIONS (
  ID      INTEGER      NOT NULL AUTO_INCREMENT,
  TYPE    VARCHAR(150) NOT NULL,
  NAME    VARCHAR(150) NOT NULL,
  CONTENT TEXT         NOT NULL,
  CONSTRAINT CONFIGURATIONS_PK PRIMARY KEY (ID),
  CONSTRAINT CONFIGURATIONS_UQ UNIQUE (TYPE, NAME)
);


CREATE TABLE SETTINGS (
  CATEGORY VARCHAR(200) NOT NULL,
  NAME     VARCHAR(150) NOT NULL,
  VALUE    TEXT         NOT NULL,
  CONSTRAINT SETTINGS_PK PRIMARY KEY (CATEGORY, NAME)
);

CREATE TABLE PREFERENCES (
  ACCOUNTID INTEGER      NOT NULL,
  TYPE      VARCHAR(150) NOT NULL,
  CONTENT   TEXT         NOT NULL,
  CONSTRAINT PREFERENCES_PK PRIMARY KEY (ACCOUNTID, TYPE),
  CONSTRAINT PREFERENCES_FK_ACCOUNT FOREIGN KEY (ACCOUNTID) REFERENCES ACCOUNTS (ID)
    ON DELETE CASCADE
);

CREATE TABLE PROPERTIES (
  ID               INTEGER      NOT NULL AUTO_INCREMENT,
  TYPE             VARCHAR(150) NOT NULL,
  PROJECT          INTEGER      NULL,
  BRANCH           INTEGER      NULL,
  PROMOTION_LEVEL  INTEGER      NULL,
  VALIDATION_STAMP INTEGER      NULL,
  BUILD            INTEGER      NULL,
  PROMOTION_RUN    INTEGER      NULL,
  VALIDATION_RUN   INTEGER      NULL,
  SEARCHKEY        VARCHAR(200) NULL,
  JSON             TEXT         NULL,
  CONSTRAINT PROPERTIES_PK PRIMARY KEY (ID),
  CONSTRAINT PROPERTIES_FK_PROJECT FOREIGN KEY (PROJECT) REFERENCES PROJECTS (ID)
    ON DELETE CASCADE,
  CONSTRAINT PROPERTIES_FK_BRANCH FOREIGN KEY (BRANCH) REFERENCES BRANCHES (ID)
    ON DELETE CASCADE,
  CONSTRAINT PROPERTIES_FK_PROMOTION_LEVEL FOREIGN KEY (PROMOTION_LEVEL) REFERENCES PROMOTION_LEVELS (ID)
    ON DELETE CASCADE,
  CONSTRAINT PROPERTIES_FK_VALIDATION_STAMP FOREIGN KEY (VALIDATION_STAMP) REFERENCES VALIDATION_STAMPS (ID)
    ON DELETE CASCADE,
  CONSTRAINT PROPERTIES_FK_BUILD FOREIGN KEY (BUILD) REFERENCES BUILDS (ID)
    ON DELETE CASCADE,
  CONSTRAINT PROPERTIES_FK_PROMOTION_RUN FOREIGN KEY (PROMOTION_RUN) REFERENCES PROMOTION_RUNS (ID)
    ON DELETE CASCADE,
  CONSTRAINT PROPERTIES_FK_VALIDATION_RUN FOREIGN KEY (VALIDATION_RUN) REFERENCES VALIDATION_RUNS (ID)
    ON DELETE CASCADE
);
