/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.repository.config;

import java.util.List;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import net.nemerosa.ontrack.model.support.DBMigrationAction;
import net.nemerosa.ontrack.repository.support.AbstractDBInitConfig;
import net.nemerosa.ontrack.repository.support.ConfiguredDBInit;
import net.nemerosa.ontrack.repository.support.DBMigrationPatch;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

@Component
public class MainDBInitConfig
extends AbstractDBInitConfig {
    public static final int VERSION = 39;
    private final ApplicationContext applicationContext;

    @Autowired
    public MainDBInitConfig(DataSource dataSource, ApplicationContext applicationContext) {
        super(dataSource);
        this.applicationContext = applicationContext;
    }

    public int getOrder() {
        return Integer.MIN_VALUE;
    }

    public String getName() {
        return "main";
    }

    public ConfiguredDBInit createConfig() {
        ConfiguredDBInit db = new ConfiguredDBInit();
        db.setVersion(39);
        db.setJdbcDataSource(this.dataSource);
        db.setVersionTable("ONTRACK_VERSION");
        db.setVersionColumnName("VALUE");
        db.setVersionColumnTimestamp("UPDATED");
        db.setResourceInitialization("/META-INF/db/init.sql");
        db.setResourceUpdate("/META-INF/db/update.{0}.sql");
        List migrationPatches = this.applicationContext.getBeansOfType(DBMigrationAction.class).values().stream().map(migrationAction -> new DBMigrationPatch(migrationAction.getPatch(), (DBMigrationAction)migrationAction)).collect(Collectors.toList());
        db.setPatchActions(migrationPatches);
        return db;
    }
}

