/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.repository.config;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.annotation.PostConstruct;
import net.nemerosa.ontrack.model.support.StartupService;
import net.nemerosa.ontrack.repository.support.ConfiguredDBInit;
import net.nemerosa.ontrack.repository.support.DBInitConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DBStartup {
    private final Logger logger = LoggerFactory.getLogger(DBStartup.class);
    private final List<DBInitConfig> dbInitConfigs;
    private final List<StartupService> startupServices;

    @Autowired
    public DBStartup(List<DBInitConfig> dbInitConfigs, List<StartupService> startupServices) {
        this.dbInitConfigs = new ArrayList<DBInitConfig>(dbInitConfigs);
        this.dbInitConfigs.sort((o1, o2) -> o2.getOrder() - o1.getOrder());
        ArrayList<StartupService> services = new ArrayList<StartupService>(startupServices);
        services.sort(Comparator.comparingInt(StartupService::startupOrder));
        this.startupServices = services;
    }

    @PostConstruct
    public void init() {
        this.logger.info("[db] DB initialisation.");
        for (DBInitConfig dbInitConfig : this.dbInitConfigs) {
            this.logger.info("[db] DB initialisation for \"{}\"", (Object)dbInitConfig.getName());
            ConfiguredDBInit dbInit = dbInitConfig.createConfig();
            dbInit.run();
        }
        this.logger.info("[startup] Running startup services");
        for (StartupService startupService : this.startupServices) {
            this.logger.info("[startup] Starting service \"{}\"", (Object)startupService.getName());
            startupService.start();
        }
    }
}

