/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.repository;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.collect.ImmutableList;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import javax.sql.DataSource;
import net.nemerosa.ontrack.model.Ack;
import net.nemerosa.ontrack.model.exceptions.ValidationStampFilterNameAlreadyDefinedException;
import net.nemerosa.ontrack.model.exceptions.ValidationStampFilterNotFoundException;
import net.nemerosa.ontrack.model.structure.Branch;
import net.nemerosa.ontrack.model.structure.ID;
import net.nemerosa.ontrack.model.structure.Project;
import net.nemerosa.ontrack.model.structure.ValidationStampFilter;
import net.nemerosa.ontrack.repository.StructureRepository;
import net.nemerosa.ontrack.repository.ValidationStampFilterRepository;
import net.nemerosa.ontrack.repository.support.AbstractJdbcRepository;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class ValidationStampFilterJdbcRepository
extends AbstractJdbcRepository
implements ValidationStampFilterRepository {
    private final StructureRepository structureRepository;

    @Autowired
    public ValidationStampFilterJdbcRepository(DataSource dataSource, StructureRepository structureRepository) {
        super(dataSource);
        this.structureRepository = structureRepository;
    }

    public List<ValidationStampFilter> getGlobalValidationStampFilters() {
        return this.getNamedParameterJdbcTemplate().query("SELECT * FROM VALIDATION_STAMP_FILTERS WHERE PROJECT IS NULL AND BRANCH IS NULL", (SqlParameterSource)this.noParams(), (rs, rowNum) -> this.toValidationStampFilter(rs, pid -> null, bid -> null));
    }

    public List<ValidationStampFilter> getProjectValidationStampFilters(Project project) {
        return this.getNamedParameterJdbcTemplate().query("SELECT * FROM VALIDATION_STAMP_FILTERS WHERE PROJECT = :project AND BRANCH IS NULL", (SqlParameterSource)this.params("project", project.id()), (rs, rowNum) -> this.toValidationStampFilter(rs, pid -> project, bid -> null));
    }

    public List<ValidationStampFilter> getBranchValidationStampFilters(Branch branch) {
        return this.getNamedParameterJdbcTemplate().query("SELECT * FROM VALIDATION_STAMP_FILTERS WHERE PROJECT IS NULL AND BRANCH = :branch", (SqlParameterSource)this.params("branch", branch.id()), (rs, rowNum) -> this.toValidationStampFilter(rs, pid -> null, bid -> branch));
    }

    public Optional<ValidationStampFilter> getValidationStampFilterByName(Branch branch, String name) {
        Optional o = this.getOptional("SELECT * FROM VALIDATION_STAMP_FILTERS WHERE PROJECT IS NULL AND BRANCH = :branch AND NAME = :name", this.params("branch", branch.id()).addValue("name", (Object)name), (rs, rowNum) -> this.toValidationStampFilter(rs, pid -> null, bid -> branch));
        if (!o.isPresent()) {
            o = this.getOptional("SELECT * FROM VALIDATION_STAMP_FILTERS WHERE PROJECT = :project AND BRANCH IS NULL AND NAME = :name", this.params("project", branch.getProject().id()).addValue("name", (Object)name), (rs, rowNum) -> this.toValidationStampFilter(rs, pid -> branch.getProject(), bid -> null));
        }
        if (!o.isPresent()) {
            o = this.getOptional("SELECT * FROM VALIDATION_STAMP_FILTERS WHERE PROJECT IS NULL AND BRANCH IS NULL AND NAME = :name", this.params("name", name), (rs, rowNum) -> this.toValidationStampFilter(rs, pid -> null, bid -> null));
        }
        return o;
    }

    public ValidationStampFilter newValidationStampFilter(ValidationStampFilter filter) {
        this.checkUnicity(filter);
        int id = this.dbCreate("INSERT INTO VALIDATION_STAMP_FILTERS(NAME, PROJECT, BRANCH, VSNAMES) VALUES (:name, :project, :branch, :vsNames)", this.params("name", filter.getName()).addValue("project", filter.getProject() != null ? Integer.valueOf(filter.getProject().id()) : null).addValue("branch", filter.getBranch() != null ? Integer.valueOf(filter.getBranch().id()) : null).addValue("vsNames", (Object)this.saveVsNames(filter.getVsNames())));
        return filter.withId(this.id(id));
    }

    private void checkUnicity(ValidationStampFilter filter) {
        Optional o;
        if (filter.getProject() != null && filter.getBranch() != null) {
            throw new IllegalStateException("Filter cannot be associated with both a project and a branch.");
        }
        MapSqlParameterSource params = this.params("name", filter.getName()).addValue("project", filter.getProject() != null ? Integer.valueOf(filter.getProject().id()) : null).addValue("branch", filter.getBranch() != null ? Integer.valueOf(filter.getBranch().id()) : null).addValue("id", filter.getId() != null && filter.getId().isSet() ? Integer.valueOf(filter.id()) : null);
        String sql = filter.getBranch() != null ? "SELECT ID FROM VALIDATION_STAMP_FILTERS WHERE PROJECT IS NULL AND BRANCH = :branch AND NAME = :name" : (filter.getProject() != null ? "SELECT ID FROM VALIDATION_STAMP_FILTERS WHERE PROJECT = :project AND BRANCH IS NULL AND NAME = :name" : "SELECT ID FROM VALIDATION_STAMP_FILTERS WHERE PROJECT IS NULL AND BRANCH IS NULL AND NAME = :name");
        if (filter.getId() != null && filter.getId().isSet()) {
            sql = sql + " AND ID <> :id";
        }
        if ((o = this.getOptional(sql, params, Integer.class)).isPresent()) {
            throw new ValidationStampFilterNameAlreadyDefinedException(filter.getName());
        }
    }

    public void saveValidationStampFilter(ValidationStampFilter filter) {
        this.checkUnicity(filter);
        this.getNamedParameterJdbcTemplate().update("UPDATE VALIDATION_STAMP_FILTERS SET NAME = :name, PROJECT = :project, BRANCH = :branch, VSNAMES = :vsNames WHERE ID = :id", (SqlParameterSource)this.params("name", filter.getName()).addValue("project", filter.getProject() != null ? Integer.valueOf(filter.getProject().id()) : null).addValue("branch", filter.getBranch() != null ? Integer.valueOf(filter.getBranch().id()) : null).addValue("vsNames", (Object)this.saveVsNames(filter.getVsNames())).addValue("id", (Object)filter.id()));
    }

    public Ack deleteValidationStampFilter(ID filterId) {
        return Ack.one((int)this.getNamedParameterJdbcTemplate().update("DELETE FROM VALIDATION_STAMP_FILTERS WHERE ID = :id", (SqlParameterSource)this.params("id", filterId.getValue())));
    }

    public ValidationStampFilter getValidationStampFilter(ID filterId) {
        try {
            return (ValidationStampFilter)this.getNamedParameterJdbcTemplate().queryForObject("SELECT * FROM VALIDATION_STAMP_FILTERS WHERE ID = :id", (SqlParameterSource)this.params("id", filterId.getValue()), (rs, rowNum) -> this.toValidationStampFilter(rs, pid -> pid != null ? this.structureRepository.getProject(ID.of((int)pid)) : null, bid -> bid != null ? this.structureRepository.getBranch(ID.of((int)bid)) : null));
        }
        catch (EmptyResultDataAccessException ex) {
            throw new ValidationStampFilterNotFoundException(filterId);
        }
    }

    public ValidationStampFilter shareValidationStampFilter(ValidationStampFilter filter, Project project) {
        ValidationStampFilter newFilter = filter.withProject(project).withBranch(null);
        this.saveValidationStampFilter(newFilter);
        return newFilter;
    }

    public ValidationStampFilter shareValidationStampFilter(ValidationStampFilter filter) {
        ValidationStampFilter newFilter = filter.withProject(null).withBranch(null);
        this.saveValidationStampFilter(newFilter);
        return newFilter;
    }

    private ValidationStampFilter toValidationStampFilter(ResultSet rs, Function<Integer, Project> projectLoader, Function<Integer, Branch> branchLoader) throws SQLException {
        return new ValidationStampFilter(this.id(rs), rs.getString("NAME"), projectLoader.apply(rs.getObject("PROJECT", Integer.class)), branchLoader.apply(rs.getObject("BRANCH", Integer.class)), this.loadVsNames(rs.getString("VSNAMES")));
    }

    private List<String> loadVsNames(String vsNames) {
        if (StringUtils.isNotBlank((CharSequence)vsNames)) {
            JsonNode json = this.readJson(vsNames);
            if (json.isArray()) {
                ArrayList<String> values = new ArrayList<String>();
                for (JsonNode node : json) {
                    values.add(node.asText());
                }
                return ImmutableList.copyOf(values);
            }
            return Collections.emptyList();
        }
        return Collections.emptyList();
    }

    private String saveVsNames(List<String> vsNames) {
        if (vsNames == null) {
            return null;
        }
        return this.writeJson(vsNames);
    }
}

