/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.repository;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDateTime;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import net.nemerosa.ontrack.common.Document;
import net.nemerosa.ontrack.model.Ack;
import net.nemerosa.ontrack.model.exceptions.BranchNameAlreadyDefinedException;
import net.nemerosa.ontrack.model.exceptions.BranchNotFoundException;
import net.nemerosa.ontrack.model.exceptions.BuildNameAlreadyDefinedException;
import net.nemerosa.ontrack.model.exceptions.BuildNotFoundException;
import net.nemerosa.ontrack.model.exceptions.ProjectNameAlreadyDefinedException;
import net.nemerosa.ontrack.model.exceptions.ProjectNotFoundException;
import net.nemerosa.ontrack.model.exceptions.PromotionLevelNameAlreadyDefinedException;
import net.nemerosa.ontrack.model.exceptions.PromotionLevelNotFoundException;
import net.nemerosa.ontrack.model.exceptions.ValidationStampNameAlreadyDefinedException;
import net.nemerosa.ontrack.model.exceptions.ValidationStampNotFoundException;
import net.nemerosa.ontrack.model.structure.Branch;
import net.nemerosa.ontrack.model.structure.BranchType;
import net.nemerosa.ontrack.model.structure.Build;
import net.nemerosa.ontrack.model.structure.BuildSortDirection;
import net.nemerosa.ontrack.model.structure.ID;
import net.nemerosa.ontrack.model.structure.NameDescription;
import net.nemerosa.ontrack.model.structure.Project;
import net.nemerosa.ontrack.model.structure.PromotionLevel;
import net.nemerosa.ontrack.model.structure.PromotionRun;
import net.nemerosa.ontrack.model.structure.Reordering;
import net.nemerosa.ontrack.model.structure.Signature;
import net.nemerosa.ontrack.model.structure.ValidationRun;
import net.nemerosa.ontrack.model.structure.ValidationRunStatus;
import net.nemerosa.ontrack.model.structure.ValidationRunStatusID;
import net.nemerosa.ontrack.model.structure.ValidationStamp;
import net.nemerosa.ontrack.repository.BranchTemplateRepository;
import net.nemerosa.ontrack.repository.StructureRepository;
import net.nemerosa.ontrack.repository.support.AbstractJdbcRepository;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class StructureJdbcRepository
extends AbstractJdbcRepository
implements StructureRepository {
    private final BranchTemplateRepository branchTemplateRepository;

    @Autowired
    public StructureJdbcRepository(DataSource dataSource, BranchTemplateRepository branchTemplateRepository) {
        super(dataSource);
        this.branchTemplateRepository = branchTemplateRepository;
    }

    public Project newProject(Project project) {
        try {
            int id = this.dbCreate("INSERT INTO PROJECTS(NAME, DESCRIPTION, DISABLED, CREATION, CREATOR) VALUES (:name, :description, :disabled, :creation, :creator)", this.params("name", project.getName()).addValue("description", (Object)project.getDescription()).addValue("disabled", (Object)project.isDisabled()).addValue("creation", (Object)StructureJdbcRepository.dateTimeForDB((LocalDateTime)project.getSignature().getTime())).addValue("creator", (Object)project.getSignature().getUser().getName()));
            return project.withId(this.id(id));
        }
        catch (DuplicateKeyException ex) {
            throw new ProjectNameAlreadyDefinedException(project.getName());
        }
    }

    public List<Project> getProjectList() {
        return this.getJdbcTemplate().query("SELECT * FROM PROJECTS ORDER BY NAME", (rs, rowNum) -> this.toProject(rs));
    }

    public Project getProject(ID projectId) {
        try {
            return (Project)this.getNamedParameterJdbcTemplate().queryForObject("SELECT * FROM PROJECTS WHERE ID = :id", (SqlParameterSource)this.params("id", projectId.getValue()), (rs, rowNum) -> this.toProject(rs));
        }
        catch (EmptyResultDataAccessException ex) {
            throw new ProjectNotFoundException(projectId);
        }
    }

    public Optional<Project> getProjectByName(String project) {
        return Optional.ofNullable(this.getFirstItem("SELECT * FROM PROJECTS WHERE NAME = :name", this.params("name", project), (rs, rowNum) -> this.toProject(rs)));
    }

    public void saveProject(Project project) {
        this.getNamedParameterJdbcTemplate().update("UPDATE PROJECTS SET NAME = :name, DESCRIPTION = :description, DISABLED = :disabled WHERE ID = :id", (SqlParameterSource)this.params("name", project.getName()).addValue("description", (Object)project.getDescription()).addValue("disabled", (Object)project.isDisabled()).addValue("id", (Object)project.getId().getValue()));
    }

    public Ack deleteProject(ID projectId) {
        return Ack.one((int)this.getNamedParameterJdbcTemplate().update("DELETE FROM PROJECTS WHERE ID = :id", (SqlParameterSource)this.params("id", projectId.getValue())));
    }

    public Branch getBranch(ID branchId) {
        try {
            return (Branch)this.getNamedParameterJdbcTemplate().queryForObject("SELECT * FROM BRANCHES WHERE ID = :id", (SqlParameterSource)this.params("id", branchId.getValue()), (rs, rowNum) -> this.toBranch(rs, this::getProject));
        }
        catch (EmptyResultDataAccessException ex) {
            throw new BranchNotFoundException(branchId);
        }
    }

    public Optional<Branch> getBranchByName(String project, String branch) {
        return this.getProjectByName(project).map(p -> (Branch)this.getFirstItem("SELECT * FROM BRANCHES WHERE PROJECTID = :project AND NAME = :name", this.params("name", branch).addValue("project", (Object)p.id()), (rs, rowNum) -> this.toBranch(rs, id -> p)));
    }

    public List<Branch> getBranchesForProject(ID projectId) {
        Project project = this.getProject(projectId);
        return this.getNamedParameterJdbcTemplate().query("SELECT * FROM BRANCHES WHERE PROJECTID = :projectId ORDER BY ID DESC", (SqlParameterSource)this.params("projectId", projectId.getValue()), (rs, rowNum) -> this.toBranch(rs, id -> project));
    }

    public Branch newBranch(Branch branch) {
        try {
            int id = this.dbCreate("INSERT INTO BRANCHES(PROJECTID, NAME, DESCRIPTION, DISABLED, CREATION, CREATOR) VALUES (:projectId, :name, :description, :disabled, :creation, :creator)", this.params("name", branch.getName()).addValue("description", (Object)branch.getDescription()).addValue("disabled", (Object)branch.isDisabled()).addValue("projectId", (Object)branch.getProject().id()).addValue("creation", (Object)StructureJdbcRepository.dateTimeForDB((LocalDateTime)branch.getSignature().getTime())).addValue("creator", (Object)branch.getSignature().getUser().getName()));
            return branch.withId(this.id(id));
        }
        catch (DuplicateKeyException ex) {
            throw new BranchNameAlreadyDefinedException(branch.getName());
        }
    }

    public void saveBranch(Branch branch) {
        try {
            this.getNamedParameterJdbcTemplate().update("UPDATE BRANCHES SET NAME = :name, DESCRIPTION = :description, DISABLED = :disabled WHERE ID = :id", (SqlParameterSource)this.params("name", branch.getName()).addValue("description", (Object)branch.getDescription()).addValue("disabled", (Object)branch.isDisabled()).addValue("id", (Object)branch.id()));
        }
        catch (DuplicateKeyException ex) {
            throw new BranchNameAlreadyDefinedException(branch.getName());
        }
    }

    public Ack deleteBranch(ID branchId) {
        return Ack.one((int)this.getNamedParameterJdbcTemplate().update("DELETE FROM BRANCHES WHERE ID = :id", (SqlParameterSource)this.params("id", branchId.getValue())));
    }

    public void builds(Branch branch, Predicate<Build> buildPredicate, BuildSortDirection sortDirection) {
        String order = sortDirection == BuildSortDirection.FROM_NEWEST ? "DESC" : "ASC";
        this.getNamedParameterJdbcTemplate().execute("SELECT * FROM BUILDS WHERE BRANCHID = :branchId ORDER BY ID " + order, (SqlParameterSource)this.params("branchId", branch.id()), ps -> {
            ResultSet rs = ps.executeQuery();
            boolean goingOn = true;
            while (rs.next() && goingOn) {
                Build build = this.toBuild(rs, id -> branch);
                goingOn = buildPredicate.test(build);
            }
            return null;
        });
    }

    public void builds(Project project, Predicate<Build> buildPredicate) {
        this.getNamedParameterJdbcTemplate().execute("SELECT B.* FROM BUILDS B INNER JOIN BRANCHES R ON R.ID = B.BRANCHID AND R.PROJECTID = :projectId ORDER BY B.ID DESC", (SqlParameterSource)this.params("projectId", project.id()), ps -> {
            ResultSet rs = ps.executeQuery();
            boolean goingOn = true;
            while (rs.next() && goingOn) {
                Build build = this.toBuild(rs, this::getBranch);
                goingOn = buildPredicate.test(build);
            }
            return null;
        });
    }

    public Build getLastBuildForBranch(Branch branch) {
        return (Build)this.getFirstItem("SELECT * FROM BUILDS WHERE BRANCHID = :branch ORDER BY ID DESC LIMIT 1", this.params("branch", branch.id()), (rs, num) -> this.toBuild(rs, id -> branch));
    }

    public Ack deleteBuild(ID buildId) {
        return Ack.one((int)this.getNamedParameterJdbcTemplate().update("DELETE FROM BUILDS WHERE ID = :id", (SqlParameterSource)this.params("id", buildId.getValue())));
    }

    public void addBuildLink(ID fromBuildId, ID toBuildId) {
        this.deleteBuildLink(fromBuildId, toBuildId);
        this.getNamedParameterJdbcTemplate().update("INSERT INTO BUILD_LINKS(BUILDID, TARGETBUILDID) VALUES (:fromBuildId, :toBuildId)", (SqlParameterSource)this.params("fromBuildId", fromBuildId.get()).addValue("toBuildId", (Object)toBuildId.get()));
    }

    public void deleteBuildLink(ID fromBuildId, ID toBuildId) {
        this.getNamedParameterJdbcTemplate().update("DELETE FROM BUILD_LINKS WHERE BUILDID = :fromBuildId AND TARGETBUILDID = :toBuildId", (SqlParameterSource)this.params("fromBuildId", fromBuildId.get()).addValue("toBuildId", (Object)toBuildId.get()));
    }

    public List<Build> getBuildLinksFrom(ID buildId) {
        return this.getNamedParameterJdbcTemplate().query("SELECT T.* FROM BUILDS T INNER JOIN BUILD_LINKS BL ON BL.TARGETBUILDID = T.ID WHERE BL.BUILDID = :buildId", (SqlParameterSource)this.params("buildId", buildId.get()), (rs, num) -> this.toBuild(rs, this::getBranch));
    }

    public List<Build> getBuildLinksTo(ID buildId) {
        return this.getNamedParameterJdbcTemplate().query("SELECT F.* FROM BUILDS F INNER JOIN BUILD_LINKS BL ON BL.BUILDID = F.ID WHERE BL.TARGETBUILDID = :buildId ORDER BY F.ID DESC", (SqlParameterSource)this.params("buildId", buildId.get()), (rs, num) -> this.toBuild(rs, this::getBranch));
    }

    public List<Build> searchBuildsLinkedTo(String projectName, String buildPattern) {
        return this.getNamedParameterJdbcTemplate().query("SELECT F.* FROM BUILDS F INNER JOIN BUILD_LINKS BL ON BL.BUILDID = F.ID INNER JOIN BUILDS T ON BL.TARGETBUILDID = T.ID INNER JOIN BRANCHES BR ON BR.ID = T.BRANCHID INNER JOIN PROJECTS P ON P.ID = BR.PROJECTID WHERE T.NAME LIKE :buildNamePattern AND P.NAME = :projectName ORDER BY F.ID DESC", (SqlParameterSource)this.params("buildNamePattern", this.expandBuildPattern(buildPattern)).addValue("projectName", (Object)projectName), (rs, num) -> this.toBuild(rs, this::getBranch));
    }

    public boolean isLinkedFrom(ID id, String project, String buildPattern) {
        return this.getOptional("SELECT BL.BUILDID FROM BUILD_LINKS BL INNER JOIN BUILDS F ON BL.BUILDID = F.ID INNER JOIN BRANCHES BR ON BR.ID = F.BRANCHID INNER JOIN PROJECTS P ON P.ID = BR.PROJECTID WHERE BL.TARGETBUILDID = :buildId AND F.NAME LIKE :buildNamePattern AND P.NAME = :projectName LIMIT 1", this.params("buildId", id.get()).addValue("buildNamePattern", (Object)this.expandBuildPattern(buildPattern)).addValue("projectName", (Object)project), Integer.class).isPresent();
    }

    private String expandBuildPattern(String buildPattern) {
        if (StringUtils.isBlank((CharSequence)buildPattern)) {
            return "%";
        }
        return StringUtils.replace((String)buildPattern, (String)"*", (String)"%");
    }

    public boolean isLinkedTo(ID id, String project, String buildPattern) {
        return this.getOptional("SELECT BL.TARGETBUILDID FROM BUILD_LINKS BL INNER JOIN BUILDS T ON BL.TARGETBUILDID = T.ID INNER JOIN BRANCHES BR ON BR.ID = T.BRANCHID INNER JOIN PROJECTS P ON P.ID = BR.PROJECTID WHERE BL.BUILDID = :buildId AND T.NAME LIKE :buildNamePattern AND P.NAME = :projectName LIMIT 1", this.params("buildId", id.get()).addValue("buildNamePattern", (Object)this.expandBuildPattern(buildPattern)).addValue("projectName", (Object)project), Integer.class).isPresent();
    }

    protected Build toBuild(ResultSet rs, Function<ID, Branch> branchSupplier) throws SQLException {
        return Build.of((Branch)branchSupplier.apply(this.id(rs, "branchId")), (NameDescription)new NameDescription(rs.getString("name"), rs.getString("description")), (Signature)this.readSignature(rs)).withId(this.id(rs));
    }

    public Build newBuild(Build build) {
        try {
            int id = this.dbCreate("INSERT INTO BUILDS(BRANCHID, NAME, DESCRIPTION, CREATION, CREATOR) VALUES (:branchId, :name, :description, :creation, :creator)", this.params("name", build.getName()).addValue("description", (Object)build.getDescription()).addValue("branchId", (Object)build.getBranch().id()).addValue("creation", (Object)StructureJdbcRepository.dateTimeForDB((LocalDateTime)build.getSignature().getTime())).addValue("creator", (Object)build.getSignature().getUser().getName()));
            return build.withId(this.id(id));
        }
        catch (DuplicateKeyException ex) {
            throw new BuildNameAlreadyDefinedException(build.getName());
        }
    }

    public Build saveBuild(Build build) {
        try {
            this.getNamedParameterJdbcTemplate().update("UPDATE BUILDS SET NAME = :name, DESCRIPTION = :description, CREATION = :creation, CREATOR = :creator WHERE ID = :id", (SqlParameterSource)this.params("name", build.getName()).addValue("description", (Object)build.getDescription()).addValue("creation", (Object)StructureJdbcRepository.dateTimeForDB((LocalDateTime)build.getSignature().getTime())).addValue("creator", (Object)build.getSignature().getUser().getName()).addValue("id", (Object)build.id()));
            return build;
        }
        catch (DuplicateKeyException ex) {
            throw new BuildNameAlreadyDefinedException(build.getName());
        }
    }

    public Build getBuild(ID buildId) {
        try {
            return (Build)this.getNamedParameterJdbcTemplate().queryForObject("SELECT * FROM BUILDS WHERE ID = :id", (SqlParameterSource)this.params("id", buildId.getValue()), (rs, rowNum) -> this.toBuild(rs, this::getBranch));
        }
        catch (EmptyResultDataAccessException ex) {
            throw new BuildNotFoundException(buildId);
        }
    }

    public Optional<Build> getBuildByName(String project, String branch, String build) {
        return this.getBranchByName(project, branch).map(b -> (Build)this.getFirstItem("SELECT * FROM BUILDS WHERE NAME = :name AND BRANCHID = :branchId", this.params("name", build).addValue("branchId", (Object)b.id()), (rs, rowNum) -> this.toBuild(rs, this::getBranch)));
    }

    public Optional<Build> findBuildAfterUsingNumericForm(ID branchId, String buildName) {
        return Optional.ofNullable(this.getFirstItem("SELECT * FROM (SELECT * FROM BUILDS WHERE BRANCHID = :branch AND NAME REGEXP '[0-9]+') WHERE CONVERT(NAME,INT) >= CONVERT(:name,INT) ORDER BY CONVERT(NAME,INT) LIMIT 1", this.params("branch", branchId.getValue()).addValue("name", (Object)buildName), (rs, rowNum) -> this.toBuild(rs, this::getBranch)));
    }

    public int getBuildCount(Branch branch) {
        return (Integer)this.getNamedParameterJdbcTemplate().queryForObject("SELECT COUNT(ID) FROM BUILDS WHERE BRANCHID = :branchId", (SqlParameterSource)this.params("branchId", branch.id()), Integer.class);
    }

    public Optional<Build> getPreviousBuild(Build build) {
        return this.getOptional("SELECT * FROM BUILDS WHERE BRANCHID = :branch AND ID < :id ORDER BY ID DESC LIMIT 1", this.params("branch", build.getBranch().id()).addValue("id", (Object)build.id()), (rs, rowNum) -> this.toBuild(rs, this::getBranch));
    }

    public Optional<Build> getNextBuild(Build build) {
        return this.getOptional("SELECT * FROM BUILDS WHERE BRANCHID = :branch AND ID > :id ORDER BY ID ASC LIMIT 1", this.params("branch", build.getBranch().id()).addValue("id", (Object)build.id()), (rs, rowNum) -> this.toBuild(rs, this::getBranch));
    }

    public List<PromotionLevel> getPromotionLevelListForBranch(ID branchId) {
        Branch branch = this.getBranch(branchId);
        return this.getNamedParameterJdbcTemplate().query("SELECT * FROM PROMOTION_LEVELS WHERE BRANCHID = :branchId ORDER BY ORDERNB", (SqlParameterSource)this.params("branchId", branchId.getValue()), (rs, rowNum) -> this.toPromotionLevel(rs, id -> branch));
    }

    public PromotionLevel newPromotionLevel(PromotionLevel promotionLevel) {
        try {
            Integer orderNbValue = (Integer)this.getFirstItem("SELECT MAX(ORDERNB) FROM promotion_levels WHERE BRANCHID = :branchId", this.params("branchId", promotionLevel.getBranch().id()), Integer.class);
            int orderNb = orderNbValue != null ? orderNbValue + 1 : 0;
            int id = this.dbCreate("INSERT INTO PROMOTION_LEVELS(BRANCHID, NAME, DESCRIPTION, ORDERNB, CREATION, CREATOR) VALUES (:branchId, :name, :description, :orderNb, :creation, :creator)", this.params("name", promotionLevel.getName()).addValue("description", (Object)promotionLevel.getDescription()).addValue("branchId", (Object)promotionLevel.getBranch().id()).addValue("orderNb", (Object)orderNb).addValue("creation", (Object)StructureJdbcRepository.dateTimeForDB((LocalDateTime)promotionLevel.getSignature().getTime())).addValue("creator", (Object)promotionLevel.getSignature().getUser().getName()));
            return promotionLevel.withId(this.id(id));
        }
        catch (DuplicateKeyException ex) {
            throw new PromotionLevelNameAlreadyDefinedException(promotionLevel.getName());
        }
    }

    public PromotionLevel getPromotionLevel(ID promotionLevelId) {
        try {
            return (PromotionLevel)this.getNamedParameterJdbcTemplate().queryForObject("SELECT * FROM PROMOTION_LEVELS WHERE ID = :id", (SqlParameterSource)this.params("id", promotionLevelId.getValue()), (rs, rowNum) -> this.toPromotionLevel(rs, this::getBranch));
        }
        catch (EmptyResultDataAccessException ex) {
            throw new PromotionLevelNotFoundException(promotionLevelId);
        }
    }

    public Optional<PromotionLevel> getPromotionLevelByName(String project, String branch, String promotionLevel) {
        return this.getBranchByName(project, branch).flatMap(b -> this.getPromotionLevelByName((Branch)b, promotionLevel));
    }

    public Optional<PromotionLevel> getPromotionLevelByName(Branch branch, String promotionLevel) {
        return this.getOptional("SELECT * FROM PROMOTION_LEVELS WHERE BRANCHID = :branch AND NAME = :name", this.params("name", promotionLevel).addValue("branch", (Object)branch.id()), (rs, rowNum) -> this.toPromotionLevel(rs, id -> branch));
    }

    public Document getPromotionLevelImage(ID promotionLevelId) {
        return this.getOptional("SELECT IMAGETYPE, IMAGEBYTES FROM PROMOTION_LEVELS WHERE ID = :id", this.params("id", promotionLevelId.getValue()), (rs, rowNum) -> this.toDocument(rs)).orElse(Document.EMPTY);
    }

    public void setPromotionLevelImage(ID promotionLevelId, Document document) {
        this.getNamedParameterJdbcTemplate().update("UPDATE PROMOTION_LEVELS SET IMAGETYPE = :type, IMAGEBYTES = :content WHERE ID = :id", (SqlParameterSource)this.params("id", promotionLevelId.getValue()).addValue("type", (Object)(document != null ? document.getType() : null)).addValue("content", (Object)(document != null ? document.getContent() : null)));
    }

    public void savePromotionLevel(PromotionLevel promotionLevel) {
        try {
            this.getNamedParameterJdbcTemplate().update("UPDATE PROMOTION_LEVELS SET NAME = :name, DESCRIPTION = :description WHERE ID = :id", (SqlParameterSource)this.params("name", promotionLevel.getName()).addValue("description", (Object)promotionLevel.getDescription()).addValue("id", (Object)promotionLevel.id()));
        }
        catch (DuplicateKeyException ex) {
            throw new PromotionLevelNameAlreadyDefinedException(promotionLevel.getName());
        }
    }

    public Ack deletePromotionLevel(ID promotionLevelId) {
        return Ack.one((int)this.getNamedParameterJdbcTemplate().update("DELETE FROM PROMOTION_LEVELS WHERE ID = :id", (SqlParameterSource)this.params("id", promotionLevelId.getValue())));
    }

    public void reorderPromotionLevels(ID branchId, Reordering reordering) {
        int order = 1;
        Iterator iterator = reordering.getIds().iterator();
        while (iterator.hasNext()) {
            int id = (Integer)iterator.next();
            this.getNamedParameterJdbcTemplate().update("UPDATE PROMOTION_LEVELS SET ORDERNB = :order WHERE ID = :id", (SqlParameterSource)this.params("id", id).addValue("order", (Object)order++));
        }
    }

    public PromotionRun newPromotionRun(PromotionRun promotionRun) {
        return promotionRun.withId(this.id(this.dbCreate("INSERT INTO PROMOTION_RUNS(BUILDID, PROMOTIONLEVELID, CREATION, CREATOR, DESCRIPTION) VALUES (:buildId, :promotionLevelId, :creation, :creator, :description)", this.params("buildId", promotionRun.getBuild().id()).addValue("promotionLevelId", (Object)promotionRun.getPromotionLevel().id()).addValue("description", (Object)promotionRun.getDescription()).addValue("creation", (Object)StructureJdbcRepository.dateTimeForDB((LocalDateTime)promotionRun.getSignature().getTime())).addValue("creator", (Object)promotionRun.getSignature().getUser().getName()))));
    }

    public PromotionRun getPromotionRun(ID promotionRunId) {
        return (PromotionRun)this.getNamedParameterJdbcTemplate().queryForObject("SELECT * FROM PROMOTION_RUNS WHERE ID = :id", (SqlParameterSource)this.params("id", promotionRunId.getValue()), (rs, rowNum) -> this.toPromotionRun(rs, this::getBuild, this::getPromotionLevel));
    }

    public Ack deletePromotionRun(ID promotionRunId) {
        return Ack.one((int)this.getNamedParameterJdbcTemplate().update("DELETE FROM PROMOTION_RUNS WHERE ID = :promotionRunId", (SqlParameterSource)this.params("promotionRunId", promotionRunId.getValue())));
    }

    public List<PromotionRun> getPromotionRunsForBuild(Build build) {
        return this.getNamedParameterJdbcTemplate().query("SELECT * FROM PROMOTION_RUNS WHERE BUILDID = :buildId ORDER BY CREATION DESC", (SqlParameterSource)this.params("buildId", build.id()), (rs, rowNum) -> this.toPromotionRun(rs, id -> build, this::getPromotionLevel));
    }

    public List<PromotionRun> getLastPromotionRunsForBuild(Build build) {
        Branch branch = build.getBranch();
        List<PromotionLevel> promotionLevels = this.getPromotionLevelListForBranch(branch.getId());
        return promotionLevels.stream().map(promotionLevel -> this.getLastPromotionRun(build, (PromotionLevel)promotionLevel)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    public PromotionRun getLastPromotionRunForPromotionLevel(PromotionLevel promotionLevel) {
        return (PromotionRun)this.getFirstItem("SELECT PR.* FROM PROMOTION_RUNS PR INNER JOIN BUILDS B ON B.ID = PR.BUILDID WHERE PROMOTIONLEVELID = :promotionLevelId ORDER BY B.ID DESC LIMIT 1", this.params("promotionLevelId", promotionLevel.id()), (rs, rowNum) -> this.toPromotionRun(rs, this::getBuild, promotionLevelId -> promotionLevel));
    }

    public Optional<PromotionRun> getLastPromotionRun(Build build, PromotionLevel promotionLevel) {
        return Optional.ofNullable(this.getFirstItem("SELECT * FROM PROMOTION_RUNS WHERE BUILDID = :buildId AND PROMOTIONLEVELID = :promotionLevelId ORDER BY CREATION DESC, ID DESC LIMIT 1", this.params("buildId", build.id()).addValue("promotionLevelId", (Object)promotionLevel.id()), (rs, rowNum) -> this.toPromotionRun(rs, id -> build, id -> promotionLevel)));
    }

    public List<PromotionRun> getPromotionRunsForBuildAndPromotionLevel(Build build, PromotionLevel promotionLevel) {
        return this.getNamedParameterJdbcTemplate().query("SELECT * FROM PROMOTION_RUNS WHERE BUILDID = :buildId AND PROMOTIONLEVELID = :promotionLevelId ORDER BY CREATION DESC, ID DESC", (SqlParameterSource)this.params("buildId", build.id()).addValue("promotionLevelId", (Object)promotionLevel.id()), (rs, rowNum) -> this.toPromotionRun(rs, id -> build, id -> promotionLevel));
    }

    public List<PromotionRun> getPromotionRunsForPromotionLevel(PromotionLevel promotionLevel) {
        return this.getNamedParameterJdbcTemplate().query("SELECT * FROM PROMOTION_RUNS WHERE PROMOTIONLEVELID = :promotionLevelId ORDER BY CREATION DESC, ID DESC", (SqlParameterSource)this.params("promotionLevelId", promotionLevel.id()), (rs, rowNum) -> this.toPromotionRun(rs, this::getBuild, id -> promotionLevel));
    }

    public Optional<PromotionRun> getEarliestPromotionRunAfterBuild(PromotionLevel promotionLevel, Build build) {
        return this.getOptional("SELECT * FROM PROMOTION_RUNS WHERE PROMOTIONLEVELID = :promotionLevelId AND BUILDID >= :buildId ORDER BY CREATION ASC, ID ASC LIMIT 1", this.params("promotionLevelId", promotionLevel.id()).addValue("buildId", (Object)build.id()), (rs, num) -> this.toPromotionRun(rs, this::getBuild, x -> promotionLevel));
    }

    protected PromotionRun toPromotionRun(ResultSet rs, Function<ID, Build> buildLoader, Function<ID, PromotionLevel> promotionLevelLoader) throws SQLException {
        return PromotionRun.of((Build)buildLoader.apply(this.id(rs, "buildId")), (PromotionLevel)promotionLevelLoader.apply(this.id(rs, "promotionLevelId")), (Signature)this.readSignature(rs), (String)rs.getString("description")).withId(this.id(rs));
    }

    public List<ValidationStamp> getValidationStampListForBranch(ID branchId) {
        Branch branch = this.getBranch(branchId);
        return this.getNamedParameterJdbcTemplate().query("SELECT * FROM VALIDATION_STAMPS WHERE BRANCHID = :branchId ORDER BY ORDERNB", (SqlParameterSource)this.params("branchId", branchId.getValue()), (rs, rowNum) -> this.toValidationStamp(rs, id -> branch));
    }

    public ValidationStamp newValidationStamp(ValidationStamp validationStamp) {
        try {
            Integer orderNbValue = (Integer)this.getFirstItem("SELECT MAX(ORDERNB) FROM VALIDATION_STAMPS WHERE BRANCHID = :branchId", this.params("branchId", validationStamp.getBranch().id()), Integer.class);
            int orderNb = orderNbValue != null ? orderNbValue + 1 : 0;
            int id = this.dbCreate("INSERT INTO VALIDATION_STAMPS(BRANCHID, NAME, DESCRIPTION, ORDERNB, CREATION, CREATOR) VALUES (:branchId, :name, :description, :orderNb, :creation, :creator)", this.params("name", validationStamp.getName()).addValue("description", (Object)validationStamp.getDescription()).addValue("branchId", (Object)validationStamp.getBranch().id()).addValue("orderNb", (Object)orderNb).addValue("creation", (Object)StructureJdbcRepository.dateTimeForDB((LocalDateTime)validationStamp.getSignature().getTime())).addValue("creator", (Object)validationStamp.getSignature().getUser().getName()));
            return validationStamp.withId(this.id(id));
        }
        catch (DuplicateKeyException ex) {
            throw new ValidationStampNameAlreadyDefinedException(validationStamp.getName());
        }
    }

    public ValidationStamp getValidationStamp(ID validationStampId) {
        try {
            return (ValidationStamp)this.getNamedParameterJdbcTemplate().queryForObject("SELECT * FROM VALIDATION_STAMPS WHERE ID = :id", (SqlParameterSource)this.params("id", validationStampId.getValue()), (rs, rowNum) -> this.toValidationStamp(rs, this::getBranch));
        }
        catch (EmptyResultDataAccessException ex) {
            throw new ValidationStampNotFoundException(validationStampId);
        }
    }

    public Optional<ValidationStamp> getValidationStampByName(String project, String branch, String validationStamp) {
        return this.getBranchByName(project, branch).flatMap(b -> this.getValidationStampByName((Branch)b, validationStamp));
    }

    public Optional<ValidationStamp> getValidationStampByName(Branch branch, String validationStamp) {
        return this.getOptional("SELECT * FROM VALIDATION_STAMPS WHERE NAME = :name AND BRANCHID = :branch", this.params("name", validationStamp).addValue("branch", (Object)branch.id()), (rs, rowNum) -> this.toValidationStamp(rs, id -> branch));
    }

    public Document getValidationStampImage(ID validationStampId) {
        return this.getOptional("SELECT IMAGETYPE, IMAGEBYTES FROM VALIDATION_STAMPS WHERE ID = :id", this.params("id", validationStampId.getValue()), (rs, rowNum) -> this.toDocument(rs)).orElse(Document.EMPTY);
    }

    public void setValidationStampImage(ID validationStampId, Document document) {
        this.getNamedParameterJdbcTemplate().update("UPDATE VALIDATION_STAMPS SET IMAGETYPE = :type, IMAGEBYTES = :content WHERE ID = :id", (SqlParameterSource)this.params("id", validationStampId.getValue()).addValue("type", (Object)(Document.isValid((Document)document) ? document.getType() : null)).addValue("content", (Object)(Document.isValid((Document)document) ? document.getContent() : null)));
    }

    public void bulkUpdateValidationStamps(ID validationStampId) {
        ValidationStamp validationStamp = this.getValidationStamp(validationStampId);
        String description = validationStamp.getDescription();
        String name = validationStamp.getName();
        Document image = this.getValidationStampImage(validationStampId);
        this.getNamedParameterJdbcTemplate().update("UPDATE VALIDATION_STAMPS SET IMAGETYPE = :type, IMAGEBYTES = :content, DESCRIPTION = :description WHERE ID <> :id AND NAME = :name", (SqlParameterSource)this.params("id", validationStampId.getValue()).addValue("name", (Object)name).addValue("description", (Object)description).addValue("type", (Object)(Document.isValid((Document)image) ? image.getType() : null)).addValue("content", (Object)(Document.isValid((Document)image) ? image.getContent() : null)));
    }

    public void saveValidationStamp(ValidationStamp validationStamp) {
        try {
            this.getNamedParameterJdbcTemplate().update("UPDATE VALIDATION_STAMPS SET NAME = :name, DESCRIPTION = :description WHERE ID = :id", (SqlParameterSource)this.params("name", validationStamp.getName()).addValue("description", (Object)validationStamp.getDescription()).addValue("id", (Object)validationStamp.id()));
        }
        catch (DuplicateKeyException ex) {
            throw new ValidationStampNameAlreadyDefinedException(validationStamp.getName());
        }
    }

    public Ack deleteValidationStamp(ID validationStampId) {
        return Ack.one((int)this.getNamedParameterJdbcTemplate().update("DELETE FROM VALIDATION_STAMPS WHERE ID = :id", (SqlParameterSource)this.params("id", validationStampId.getValue())));
    }

    public void reorderValidationStamps(ID branchId, Reordering reordering) {
        int order = 1;
        Iterator iterator = reordering.getIds().iterator();
        while (iterator.hasNext()) {
            int id = (Integer)iterator.next();
            this.getNamedParameterJdbcTemplate().update("UPDATE VALIDATION_STAMPS SET ORDERNB = :order WHERE ID = :id", (SqlParameterSource)this.params("id", id).addValue("order", (Object)order++));
        }
    }

    public ValidationRun newValidationRun(ValidationRun validationRun, Function<String, ValidationRunStatusID> validationRunStatusService) {
        int id = this.dbCreate("INSERT INTO VALIDATION_RUNS(BUILDID, VALIDATIONSTAMPID) VALUES (:buildId, :validationStampId)", this.params("buildId", validationRun.getBuild().id()).addValue("validationStampId", (Object)validationRun.getValidationStamp().id()));
        validationRun.getValidationRunStatuses().forEach(validationRunStatus -> this.newValidationRunStatus(id, (ValidationRunStatus)validationRunStatus));
        return this.getValidationRun(ID.of((int)id), validationRunStatusService);
    }

    public ValidationRun getValidationRun(ID validationRunId, Function<String, ValidationRunStatusID> validationRunStatusService) {
        return (ValidationRun)this.getNamedParameterJdbcTemplate().queryForObject("SELECT * FROM VALIDATION_RUNS WHERE ID = :id", (SqlParameterSource)this.params("id", validationRunId.getValue()), (rs, rowNum) -> this.toValidationRun(rs, this::getBuild, this::getValidationStamp, validationRunStatusService));
    }

    public List<ValidationRun> getValidationRunsForBuild(Build build, Function<String, ValidationRunStatusID> validationRunStatusService) {
        return this.getNamedParameterJdbcTemplate().query("SELECT * FROM VALIDATION_RUNS WHERE BUILDID = :buildId", (SqlParameterSource)this.params("buildId", build.id()), (rs, rowNum) -> this.toValidationRun(rs, id -> build, this::getValidationStamp, validationRunStatusService));
    }

    public List<ValidationRun> getValidationRunsForBuildAndValidationStamp(Build build, ValidationStamp validationStamp, Function<String, ValidationRunStatusID> validationRunStatusService) {
        return this.getNamedParameterJdbcTemplate().query("SELECT * FROM VALIDATION_RUNS WHERE BUILDID = :buildId AND VALIDATIONSTAMPID = :validationStampId ORDER BY ID DESC", (SqlParameterSource)this.params("buildId", build.id()).addValue("validationStampId", (Object)validationStamp.id()), (rs, rowNum) -> this.toValidationRun(rs, id -> build, id -> validationStamp, validationRunStatusService));
    }

    public List<ValidationRun> getValidationRunsForValidationStamp(ValidationStamp validationStamp, int offset, int count, Function<String, ValidationRunStatusID> validationRunStatusService) {
        return this.getNamedParameterJdbcTemplate().query("SELECT * FROM VALIDATION_RUNS WHERE VALIDATIONSTAMPID = :validationStampId ORDER BY BUILDID DESC, ID DESC LIMIT :limit OFFSET :offset", (SqlParameterSource)this.params("validationStampId", validationStamp.id()).addValue("limit", (Object)count).addValue("offset", (Object)offset), (rs, rowNum) -> this.toValidationRun(rs, this::getBuild, id -> validationStamp, validationRunStatusService));
    }

    public ValidationRun newValidationRunStatus(ValidationRun validationRun, ValidationRunStatus runStatus) {
        this.newValidationRunStatus(validationRun.id(), runStatus);
        return validationRun.add(runStatus);
    }

    protected void newValidationRunStatus(int validationRunId, ValidationRunStatus validationRunStatus) {
        this.dbCreate("INSERT INTO VALIDATION_RUN_STATUSES(VALIDATIONRUNID, VALIDATIONRUNSTATUSID, CREATION, CREATOR, DESCRIPTION) VALUES (:validationRunId, :validationRunStatusId, :creation, :creator, :description)", this.params("validationRunId", validationRunId).addValue("validationRunStatusId", (Object)validationRunStatus.getStatusID().getId()).addValue("description", (Object)validationRunStatus.getDescription()).addValue("creation", (Object)StructureJdbcRepository.dateTimeForDB((LocalDateTime)validationRunStatus.getSignature().getTime())).addValue("creator", (Object)validationRunStatus.getSignature().getUser().getName()));
    }

    protected ValidationRun toValidationRun(ResultSet rs, Function<ID, Build> buildSupplier, Function<ID, ValidationStamp> validationStampSupplier, Function<String, ValidationRunStatusID> validationRunStatusService) throws SQLException {
        int id = rs.getInt("id");
        List statuses = this.getNamedParameterJdbcTemplate().query("SELECT * FROM VALIDATION_RUN_STATUSES WHERE VALIDATIONRUNID = :validationRunId ORDER BY CREATION DESC", (SqlParameterSource)this.params("validationRunId", id), (rs1, rowNum) -> ValidationRunStatus.of((Signature)this.readSignature(rs1), (ValidationRunStatusID)((ValidationRunStatusID)validationRunStatusService.apply(rs1.getString("validationRunStatusId"))), (String)rs1.getString("description")));
        ID buildId = this.id(rs, "buildId");
        ID validationStampId = this.id(rs, "validationStampId");
        int runOrder = (Integer)this.getNamedParameterJdbcTemplate().queryForObject("SELECT COUNT(*) FROM VALIDATION_RUNS WHERE BUILDID=:buildId AND VALIDATIONSTAMPID=:validationStampId AND ID <= :id", (SqlParameterSource)this.params("id", id).addValue("buildId", (Object)buildId.getValue()).addValue("validationStampId", (Object)validationStampId.getValue()), Integer.class);
        return ValidationRun.of((Build)buildSupplier.apply(buildId), (ValidationStamp)validationStampSupplier.apply(validationStampId), (int)runOrder, (List)statuses).withId(ID.of((int)id));
    }

    protected PromotionLevel toPromotionLevel(ResultSet rs, Function<ID, Branch> branchSupplier) throws SQLException {
        return PromotionLevel.of((Branch)branchSupplier.apply(this.id(rs, "branchId")), (NameDescription)new NameDescription(rs.getString("name"), rs.getString("description"))).withId(this.id(rs)).withSignature(this.readSignature(rs)).withImage(StringUtils.isNotBlank((CharSequence)rs.getString("imagetype")));
    }

    protected ValidationStamp toValidationStamp(ResultSet rs, Function<ID, Branch> branchSupplier) throws SQLException {
        return ValidationStamp.of((Branch)branchSupplier.apply(this.id(rs, "branchId")), (NameDescription)new NameDescription(rs.getString("name"), rs.getString("description"))).withId(this.id(rs)).withSignature(this.readSignature(rs)).withImage(StringUtils.isNotBlank((CharSequence)rs.getString("imagetype")));
    }

    protected Branch toBranch(ResultSet rs, Function<ID, Project> projectSupplier) throws SQLException {
        ID projectId = this.id(rs, "projectId");
        ID branchId = this.id(rs);
        return Branch.of((Project)projectSupplier.apply(projectId), (NameDescription)new NameDescription(rs.getString("name"), rs.getString("description"))).withId(branchId).withSignature(this.readSignature(rs)).withType(this.getBranchType(branchId)).withDisabled(rs.getBoolean("disabled"));
    }

    private BranchType getBranchType(ID branchId) {
        if (this.branchTemplateRepository.isTemplateDefinition(branchId)) {
            return BranchType.TEMPLATE_DEFINITION;
        }
        if (this.branchTemplateRepository.isTemplateInstance(branchId)) {
            return BranchType.TEMPLATE_INSTANCE;
        }
        return BranchType.CLASSIC;
    }

    protected Project toProject(ResultSet rs) throws SQLException {
        return Project.of((NameDescription)new NameDescription(rs.getString("name"), rs.getString("description"))).withId(this.id(rs.getInt("id"))).withSignature(this.readSignature(rs)).withDisabled(rs.getBoolean("disabled"));
    }
}

