/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.repository;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.sql.DataSource;
import net.nemerosa.ontrack.repository.StorageRepository;
import net.nemerosa.ontrack.repository.support.AbstractJdbcRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class StorageJdbcRepository
extends AbstractJdbcRepository
implements StorageRepository {
    @Autowired
    public StorageJdbcRepository(DataSource dataSource) {
        super(dataSource);
    }

    public void storeJson(String store, String key, JsonNode node) {
        MapSqlParameterSource params = this.params("store", store).addValue("key", (Object)key);
        this.getNamedParameterJdbcTemplate().update("DELETE FROM STORAGE WHERE STORE = :store AND NAME = :key", (SqlParameterSource)params);
        if (node != null) {
            this.getNamedParameterJdbcTemplate().update("INSERT INTO STORAGE(STORE, NAME, DATA) VALUES (:store, :key, :data)", (SqlParameterSource)params.addValue("data", (Object)this.writeJson(node)));
        }
    }

    public Optional<JsonNode> retrieveJson(String store, String key) {
        return this.getOptional("SELECT DATA FROM STORAGE WHERE STORE = :store AND NAME = :key", this.params("store", store).addValue("key", (Object)key), (rs, rowNum) -> this.readJson(rs, "DATA"));
    }

    public List<String> getKeys(String store) {
        return this.getNamedParameterJdbcTemplate().queryForList("SELECT NAME FROM STORAGE WHERE STORE = :store ORDER BY NAME", (SqlParameterSource)this.params("store", store), String.class);
    }

    public Map<String, JsonNode> getData(String store) {
        LinkedHashMap<String, JsonNode> results = new LinkedHashMap<String, JsonNode>();
        this.getNamedParameterJdbcTemplate().query("SELECT NAME, DATA FROM STORAGE WHERE STORE = :store ORDER BY NAME", (SqlParameterSource)this.params("store", store), rs -> {
            String name = rs.getString("NAME");
            JsonNode node = this.readJson(rs, "DATA");
            results.put(name, node);
        });
        return results;
    }
}

