/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.repository;

import java.util.function.Function;
import javax.sql.DataSource;
import net.nemerosa.ontrack.model.support.SettingsRepository;
import net.nemerosa.ontrack.repository.support.AbstractJdbcRepository;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class SettingsJdbcRepository
extends AbstractJdbcRepository
implements SettingsRepository {
    @Autowired
    public SettingsJdbcRepository(DataSource dataSource) {
        super(dataSource);
    }

    public void delete(Class<?> category, String name) {
        MapSqlParameterSource params = this.params("category", category.getName()).addValue("name", (Object)name);
        this.getNamedParameterJdbcTemplate().update("DELETE FROM SETTINGS WHERE CATEGORY = :category AND NAME = :name", (SqlParameterSource)params);
    }

    public boolean getBoolean(Class<?> category, String name, boolean defaultValue) {
        return this.getValue(category, name, Boolean::valueOf, defaultValue);
    }

    public void setBoolean(Class<?> category, String name, boolean value) {
        this.setValue(category, name, String.valueOf(value));
    }

    public int getInt(Class<?> category, String name, int defaultValue) {
        return this.getValue(category, name, s -> Integer.parseInt(s, 10), defaultValue);
    }

    public void setInt(Class<?> category, String name, int value) {
        this.setValue(category, name, String.valueOf(value));
    }

    public String getString(Class<?> category, String name, String defaultValue) {
        return this.getValue(category, name, Function.identity(), defaultValue);
    }

    public void setString(Class<?> category, String name, String value) {
        this.setValue(category, name, value);
    }

    public String getPassword(Class<?> category, String name, String defaultValue, Function<String, String> decryptService) {
        return this.getValue(category, name, decryptService, defaultValue);
    }

    public void setPassword(Class<?> category, String name, String plain, boolean dontSaveIfBlank, Function<String, String> encryptService) {
        if (!StringUtils.isBlank((CharSequence)plain) || !dontSaveIfBlank) {
            this.setValue(category, name, encryptService.apply(plain));
        }
    }

    protected void setValue(Class<?> category, String name, String value) {
        MapSqlParameterSource params = this.params("category", category.getName()).addValue("name", (Object)name);
        this.getNamedParameterJdbcTemplate().update("DELETE FROM SETTINGS WHERE CATEGORY = :category AND NAME = :name", (SqlParameterSource)params);
        this.getNamedParameterJdbcTemplate().update("INSERT INTO SETTINGS (CATEGORY, NAME, VALUE) VALUES (:category, :name, :value)", (SqlParameterSource)params.addValue("value", (Object)value));
    }

    protected <T> T getValue(Class<?> category, String name, Function<String, T> converter, T defaultValue) {
        String value = (String)this.getFirstItem("SELECT VALUE FROM SETTINGS WHERE CATEGORY = :category AND NAME = :name", this.params("category", category.getName()).addValue("name", (Object)name), String.class);
        if (StringUtils.isBlank((CharSequence)value)) {
            return defaultValue;
        }
        return converter.apply(value);
    }
}

