/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.repository;

import java.util.Collection;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import net.nemerosa.ontrack.model.Ack;
import net.nemerosa.ontrack.model.security.Account;
import net.nemerosa.ontrack.model.security.AccountGroup;
import net.nemerosa.ontrack.model.security.GlobalRole;
import net.nemerosa.ontrack.model.security.ProjectRole;
import net.nemerosa.ontrack.model.security.ProjectRoleAssociation;
import net.nemerosa.ontrack.model.structure.ID;
import net.nemerosa.ontrack.model.structure.Project;
import net.nemerosa.ontrack.repository.RoleRepository;
import net.nemerosa.ontrack.repository.support.AbstractJdbcRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class RoleJdbcRepository
extends AbstractJdbcRepository
implements RoleRepository {
    @Autowired
    public RoleJdbcRepository(DataSource dataSource) {
        super(dataSource);
    }

    public Optional<String> findGlobalRoleByAccount(int accountId) {
        return Optional.ofNullable(this.getFirstItem("SELECT ROLE FROM GLOBAL_AUTHORIZATIONS WHERE ACCOUNT = :accountId", this.params("accountId", accountId), String.class));
    }

    public Optional<String> findGlobalRoleByGroup(int groupId) {
        return Optional.ofNullable(this.getFirstItem("SELECT ROLE FROM GROUP_GLOBAL_AUTHORIZATIONS WHERE ACCOUNTGROUP = :groupId", this.params("groupId", groupId), String.class));
    }

    public Ack deleteGlobalRoleForAccount(int accountId) {
        return Ack.one((int)this.getNamedParameterJdbcTemplate().update("DELETE FROM GLOBAL_AUTHORIZATIONS WHERE ACCOUNT = :accountId", (SqlParameterSource)this.params("accountId", accountId)));
    }

    public Ack deleteGlobalRoleForGroup(int groupId) {
        return Ack.one((int)this.getNamedParameterJdbcTemplate().update("DELETE FROM GROUP_GLOBAL_AUTHORIZATIONS WHERE ACCOUNTGROUP = :groupId", (SqlParameterSource)this.params("groupId", groupId)));
    }

    public Ack saveProjectRoleForAccount(int projectId, int accountId, String role) {
        this.getNamedParameterJdbcTemplate().update("DELETE FROM PROJECT_AUTHORIZATIONS WHERE ACCOUNT = :accountId AND PROJECT = :projectId", (SqlParameterSource)this.params("accountId", accountId).addValue("projectId", (Object)projectId));
        return Ack.one((int)this.getNamedParameterJdbcTemplate().update("INSERT INTO PROJECT_AUTHORIZATIONS (PROJECT, ACCOUNT, ROLE) VALUES (:projectId, :accountId, :role)", (SqlParameterSource)this.params("accountId", accountId).addValue("role", (Object)role).addValue("projectId", (Object)projectId)));
    }

    public Ack saveProjectRoleForGroup(int projectId, int groupId, String role) {
        this.getNamedParameterJdbcTemplate().update("DELETE FROM GROUP_PROJECT_AUTHORIZATIONS WHERE ACCOUNTGROUP = :groupId AND PROJECT = :projectId", (SqlParameterSource)this.params("groupId", groupId).addValue("projectId", (Object)projectId));
        return Ack.one((int)this.getNamedParameterJdbcTemplate().update("INSERT INTO GROUP_PROJECT_AUTHORIZATIONS (PROJECT, ACCOUNTGROUP, ROLE) VALUES (:projectId, :groupId, :role)", (SqlParameterSource)this.params("groupId", groupId).addValue("role", (Object)role).addValue("projectId", (Object)projectId)));
    }

    public Ack deleteProjectRoleForAccount(int projectId, int accountId) {
        return Ack.one((int)this.getNamedParameterJdbcTemplate().update("DELETE FROM PROJECT_AUTHORIZATIONS WHERE ACCOUNT = :accountId AND PROJECT = :projectId", (SqlParameterSource)this.params("accountId", accountId).addValue("projectId", (Object)projectId)));
    }

    public Ack deleteProjectRoleForGroup(int projectId, int accountGroupId) {
        return Ack.one((int)this.getNamedParameterJdbcTemplate().update("DELETE FROM GROUP_PROJECT_AUTHORIZATIONS WHERE ACCOUNTGROUP = :accountGroupId AND PROJECT = :projectId", (SqlParameterSource)this.params("accountGroupId", accountGroupId).addValue("projectId", (Object)projectId)));
    }

    public Collection<AccountGroup> findAccountGroupsByGlobalRole(GlobalRole globalRole, Function<ID, AccountGroup> accountGroupLoader) {
        return this.getNamedParameterJdbcTemplate().query("SELECT G.* FROM ACCOUNT_GROUPS G INNER JOIN GROUP_GLOBAL_AUTHORIZATIONS A ON A.ACCOUNTGROUP = G.ID WHERE A.ROLE = :role ORDER BY G.NAME", (SqlParameterSource)this.params("role", globalRole.getId()), (rs, num) -> (AccountGroup)accountGroupLoader.apply(this.id(rs)));
    }

    public Collection<Account> findAccountsByGlobalRole(GlobalRole globalRole, Function<ID, Account> accountLoader) {
        return this.getNamedParameterJdbcTemplate().query("SELECT G.* FROM ACCOUNTS G INNER JOIN GLOBAL_AUTHORIZATIONS A ON A.ACCOUNT = G.ID WHERE A.ROLE = :role ORDER BY G.NAME", (SqlParameterSource)this.params("role", globalRole.getId()), (rs, num) -> (Account)accountLoader.apply(this.id(rs)));
    }

    public Collection<AccountGroup> findAccountGroupsByProjectRole(Project project, ProjectRole projectRole, Function<ID, AccountGroup> accountGroupLoader) {
        return this.getNamedParameterJdbcTemplate().query("SELECT G.* FROM ACCOUNT_GROUPS G INNER JOIN GROUP_PROJECT_AUTHORIZATIONS A ON A.ACCOUNTGROUP = G.ID WHERE A.ROLE = :role AND A.PROJECT = :project ORDER BY G.NAME", (SqlParameterSource)this.params("role", projectRole.getId()).addValue("project", (Object)project.id()), (rs, num) -> (AccountGroup)accountGroupLoader.apply(this.id(rs)));
    }

    public Collection<Account> findAccountsByProjectRole(Project project, ProjectRole projectRole, Function<ID, Account> accountLoader) {
        return this.getNamedParameterJdbcTemplate().query("SELECT G.* FROM ACCOUNTS G INNER JOIN PROJECT_AUTHORIZATIONS A ON A.ACCOUNT = G.ID WHERE A.ROLE = :role AND A.PROJECT = :project ORDER BY G.NAME", (SqlParameterSource)this.params("role", projectRole.getId()).addValue("project", (Object)project.id()), (rs, num) -> (Account)accountLoader.apply(this.id(rs)));
    }

    public Collection<ProjectRoleAssociation> findProjectRoleAssociationsByAccount(int accountId, BiFunction<Integer, String, Optional<ProjectRoleAssociation>> projectRoleAssociationMapper) {
        return this.getNamedParameterJdbcTemplate().query("SELECT PROJECT, ROLE FROM PROJECT_AUTHORIZATIONS WHERE ACCOUNT = :accountId", (SqlParameterSource)this.params("accountId", accountId), (rs, rowNum) -> (Optional)projectRoleAssociationMapper.apply(rs.getInt("project"), rs.getString("role"))).stream().filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    public Optional<ProjectRoleAssociation> findProjectRoleAssociationsByAccount(int accountId, int projectId, BiFunction<Integer, String, Optional<ProjectRoleAssociation>> projectRoleAssociationMapper) {
        Optional<ProjectRoleAssociation> value = (Optional<ProjectRoleAssociation>)this.getFirstItem("SELECT PROJECT, ROLE FROM PROJECT_AUTHORIZATIONS WHERE ACCOUNT = :accountId AND PROJECT = :projectId", this.params("accountId", accountId).addValue("projectId", (Object)projectId), (rs, rowNum) -> (Optional)projectRoleAssociationMapper.apply(rs.getInt("project"), rs.getString("role")));
        return value != null ? value : Optional.empty();
    }

    public Collection<ProjectRoleAssociation> findProjectRoleAssociationsByGroup(int groupId, BiFunction<Integer, String, Optional<ProjectRoleAssociation>> projectRoleAssociationMapper) {
        return this.getNamedParameterJdbcTemplate().query("SELECT PROJECT, ROLE FROM GROUP_PROJECT_AUTHORIZATIONS WHERE ACCOUNTGROUP = :groupId", (SqlParameterSource)this.params("groupId", groupId), (rs, rowNum) -> (Optional)projectRoleAssociationMapper.apply(rs.getInt("project"), rs.getString("role"))).stream().filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    public Optional<ProjectRoleAssociation> findProjectRoleAssociationsByGroup(int groupId, int projectId, BiFunction<Integer, String, Optional<ProjectRoleAssociation>> projectRoleAssociationMapper) {
        Optional<ProjectRoleAssociation> firstItem = (Optional<ProjectRoleAssociation>)this.getFirstItem("SELECT PROJECT, ROLE FROM GROUP_PROJECT_AUTHORIZATIONS WHERE ACCOUNTGROUP = :groupId AND PROJECT = :projectId", this.params("groupId", groupId).addValue("projectId", (Object)projectId), (rs, rowNum) -> (Optional)projectRoleAssociationMapper.apply(rs.getInt("project"), rs.getString("role")));
        return firstItem != null ? firstItem : Optional.empty();
    }

    public Ack saveGlobalRoleForAccount(int accountId, String role) {
        this.getNamedParameterJdbcTemplate().update("DELETE FROM GLOBAL_AUTHORIZATIONS WHERE ACCOUNT = :accountId", (SqlParameterSource)this.params("accountId", accountId));
        return Ack.one((int)this.getNamedParameterJdbcTemplate().update("INSERT INTO GLOBAL_AUTHORIZATIONS (ACCOUNT, ROLE) VALUES (:accountId, :role)", (SqlParameterSource)this.params("accountId", accountId).addValue("role", (Object)role)));
    }

    public Ack saveGlobalRoleForGroup(int groupId, String role) {
        this.getNamedParameterJdbcTemplate().update("DELETE FROM GROUP_GLOBAL_AUTHORIZATIONS WHERE ACCOUNTGROUP = :groupId", (SqlParameterSource)this.params("groupId", groupId));
        return Ack.one((int)this.getNamedParameterJdbcTemplate().update("INSERT INTO GROUP_GLOBAL_AUTHORIZATIONS (ACCOUNTGROUP, ROLE) VALUES (:groupId, :role)", (SqlParameterSource)this.params("groupId", groupId).addValue("role", (Object)role)));
    }
}

