/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.repository;

import com.fasterxml.jackson.databind.JsonNode;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import javax.sql.DataSource;
import net.nemerosa.ontrack.model.Ack;
import net.nemerosa.ontrack.model.structure.ID;
import net.nemerosa.ontrack.model.structure.ProjectEntity;
import net.nemerosa.ontrack.model.structure.ProjectEntityType;
import net.nemerosa.ontrack.repository.PropertyRepository;
import net.nemerosa.ontrack.repository.TProperty;
import net.nemerosa.ontrack.repository.support.AbstractJdbcRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class PropertyJdbcRepository
extends AbstractJdbcRepository
implements PropertyRepository {
    @Autowired
    public PropertyJdbcRepository(DataSource dataSource) {
        super(dataSource);
    }

    @Cacheable(cacheNames={"properties"}, key="#typeName + #entityType.name() + #entityId.value")
    public TProperty loadProperty(String typeName, ProjectEntityType entityType, ID entityId) {
        return (TProperty)this.getFirstItem(String.format("SELECT * FROM PROPERTIES WHERE TYPE = :type AND %s = :entityId", entityType.name()), this.params("type", typeName).addValue("entityId", (Object)entityId.getValue()), (rs, rowNum) -> this.toProperty(rs));
    }

    @CacheEvict(cacheNames={"properties"}, key="#typeName + #entityType.name() + #entityId.value")
    public void saveProperty(String typeName, ProjectEntityType entityType, ID entityId, JsonNode data, String searchKey) {
        MapSqlParameterSource params = this.params("type", typeName).addValue("entityId", (Object)entityId.getValue());
        Integer propertyId = (Integer)this.getFirstItem(String.format("SELECT ID FROM PROPERTIES WHERE TYPE = :type AND %s = :entityId", entityType.name()), params, Integer.class);
        params.addValue("json", (Object)this.writeJson(data)).addValue("searchKey", (Object)searchKey);
        if (propertyId != null) {
            this.getNamedParameterJdbcTemplate().update("UPDATE PROPERTIES SET JSON = :json, SEARCHKEY = :searchKey WHERE ID = :id", (SqlParameterSource)params.addValue("id", (Object)propertyId));
        } else {
            this.getNamedParameterJdbcTemplate().update(String.format("INSERT INTO PROPERTIES(TYPE, %s, SEARCHKEY, JSON) VALUES(:type, :entityId, :searchKey, :json)", entityType.name()), (SqlParameterSource)params);
        }
    }

    @CacheEvict(cacheNames={"properties"}, key="#typeName + #entityType.name() + #entityId.value")
    public Ack deleteProperty(String typeName, ProjectEntityType entityType, ID entityId) {
        return Ack.one((int)this.getNamedParameterJdbcTemplate().update(String.format("DELETE FROM PROPERTIES WHERE TYPE = :type AND %s = :entityId", entityType.name()), (SqlParameterSource)this.params("type", typeName).addValue("entityId", (Object)entityId.getValue())));
    }

    public Collection<ProjectEntity> searchByProperty(String typeName, BiFunction<ProjectEntityType, ID, ProjectEntity> entityLoader, Predicate<TProperty> predicate) {
        return (Collection)this.getNamedParameterJdbcTemplate().execute("SELECT * FROM PROPERTIES WHERE TYPE = :type ORDER BY ID DESC", (SqlParameterSource)this.params("type", typeName), ps -> {
            ArrayList entities = new ArrayList();
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                TProperty t = this.toProperty(rs);
                if (!predicate.test(t)) continue;
                entities.add(entityLoader.apply(t.getEntityType(), t.getEntityId()));
            }
            return entities;
        });
    }

    private TProperty toProperty(ResultSet rs) throws SQLException {
        int id = rs.getInt("id");
        String searchKey = rs.getString("searchKey");
        String typeName = rs.getString("type");
        ProjectEntityType entityType = null;
        ID entityId = null;
        for (ProjectEntityType candidate : ProjectEntityType.values()) {
            Integer candidateId = rs.getInt(candidate.name());
            if (rs.wasNull()) continue;
            entityType = candidate;
            entityId = ID.of((int)candidateId);
        }
        if (entityType == null || !ID.isDefined(entityId)) {
            throw new IllegalStateException(String.format("Could not find any entity for property %s with key %s (id = %d)", typeName, searchKey, id));
        }
        return new TProperty(typeName, entityType, entityId, searchKey, this.readJson(rs, "json"));
    }
}

