/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.repository;

import javax.sql.DataSource;
import net.nemerosa.ontrack.repository.ProjectFavouriteRepository;
import net.nemerosa.ontrack.repository.support.AbstractJdbcRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class ProjectFavouriteJdbcRepository
extends AbstractJdbcRepository
implements ProjectFavouriteRepository {
    @Autowired
    public ProjectFavouriteJdbcRepository(DataSource dataSource) {
        super(dataSource);
    }

    public boolean isProjectFavourite(int accountId, int projectId) {
        return this.getOptional("SELECT ID FROM PROJECT_FAVOURITES WHERE ACCOUNTID = :account AND PROJECTID = :project", this.params("account", accountId).addValue("project", (Object)projectId), Integer.class).isPresent();
    }

    public void setProjectFavourite(int accountId, int projectId, boolean favourite) {
        if (favourite) {
            if (!this.isProjectFavourite(accountId, projectId)) {
                this.getNamedParameterJdbcTemplate().update("INSERT INTO PROJECT_FAVOURITES(ACCOUNTID, PROJECTID) VALUES (:account, :project)", (SqlParameterSource)this.params("account", accountId).addValue("project", (Object)projectId));
            }
        } else {
            this.getNamedParameterJdbcTemplate().update("DELETE FROM PROJECT_FAVOURITES WHERE ACCOUNTID = :account AND PROJECTID = :project", (SqlParameterSource)this.params("account", accountId).addValue("project", (Object)projectId));
        }
    }
}

