/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.repository;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.Optional;
import javax.sql.DataSource;
import net.nemerosa.ontrack.repository.PreferencesRepository;
import net.nemerosa.ontrack.repository.support.AbstractJdbcRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class PreferencesJdbcRepository
extends AbstractJdbcRepository
implements PreferencesRepository {
    @Autowired
    public PreferencesJdbcRepository(DataSource dataSource) {
        super(dataSource);
    }

    public Optional<JsonNode> find(int accountId, String type) {
        return Optional.ofNullable(this.getFirstItem("SELECT CONTENT FROM PREFERENCES WHERE ACCOUNTID = :accountId AND TYPE = :type", this.params("accountId", accountId).addValue("type", (Object)type), String.class)).map(arg_0 -> ((PreferencesJdbcRepository)this).readJson(arg_0));
    }

    public void store(int accountId, String type, JsonNode data) {
        NamedParameterJdbcTemplate t = this.getNamedParameterJdbcTemplate();
        MapSqlParameterSource params = this.params("accountId", accountId).addValue("type", (Object)type);
        t.update("DELETE FROM PREFERENCES WHERE ACCOUNTID = :accountId AND TYPE = :type", (SqlParameterSource)params);
        t.update("INSERT INTO PREFERENCES(ACCOUNTID, TYPE, CONTENT) VALUES (:accountId, :type, :content)", (SqlParameterSource)params.addValue("content", (Object)this.writeJson(data)));
    }
}

