/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.repository;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Optional;
import javax.sql.DataSource;
import net.nemerosa.ontrack.common.Document;
import net.nemerosa.ontrack.model.Ack;
import net.nemerosa.ontrack.model.exceptions.PredefinedValidationStampNameAlreadyDefinedException;
import net.nemerosa.ontrack.model.structure.ID;
import net.nemerosa.ontrack.model.structure.NameDescription;
import net.nemerosa.ontrack.model.structure.PredefinedValidationStamp;
import net.nemerosa.ontrack.repository.PredefinedValidationStampRepository;
import net.nemerosa.ontrack.repository.support.AbstractJdbcRepository;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class PredefinedValidationStampJdbcRepository
extends AbstractJdbcRepository
implements PredefinedValidationStampRepository {
    @Autowired
    public PredefinedValidationStampJdbcRepository(DataSource dataSource) {
        super(dataSource);
    }

    public List<PredefinedValidationStamp> getPredefinedValidationStamps() {
        return this.getJdbcTemplate().query("SELECT * FROM PREDEFINED_VALIDATION_STAMPS ORDER BY NAME", (rs, rowNum) -> this.toPredefinedValidationStamp(rs));
    }

    public ID newPredefinedValidationStamp(PredefinedValidationStamp stamp) {
        try {
            return ID.of((int)this.dbCreate("INSERT INTO PREDEFINED_VALIDATION_STAMPS(NAME, DESCRIPTION) VALUES (:name, :description)", this.params("name", stamp.getName()).addValue("description", (Object)stamp.getDescription())));
        }
        catch (DuplicateKeyException ex) {
            throw new PredefinedValidationStampNameAlreadyDefinedException(stamp.getName());
        }
    }

    public PredefinedValidationStamp getPredefinedValidationStamp(ID id) {
        return (PredefinedValidationStamp)this.getNamedParameterJdbcTemplate().queryForObject("SELECT * FROM PREDEFINED_VALIDATION_STAMPS WHERE ID = :id", (SqlParameterSource)this.params("id", id.get()), (rs, rowNum) -> this.toPredefinedValidationStamp(rs));
    }

    public Optional<PredefinedValidationStamp> findPredefinedValidationStampByName(String name) {
        return this.getOptional("SELECT * FROM PREDEFINED_VALIDATION_STAMPS WHERE NAME = :name", this.params("name", name), (rs, rowNum) -> this.toPredefinedValidationStamp(rs));
    }

    public Document getPredefinedValidationStampImage(ID id) {
        return this.getOptional("SELECT IMAGETYPE, IMAGEBYTES FROM PREDEFINED_VALIDATION_STAMPS WHERE ID = :id", this.params("id", id.getValue()), (rs, rowNum) -> this.toDocument(rs)).orElse(Document.EMPTY);
    }

    public void savePredefinedValidationStamp(PredefinedValidationStamp validationStamp) {
        try {
            this.getNamedParameterJdbcTemplate().update("UPDATE PREDEFINED_VALIDATION_STAMPS SET NAME = :name, DESCRIPTION = :description WHERE ID = :id", (SqlParameterSource)this.params("name", validationStamp.getName()).addValue("description", (Object)validationStamp.getDescription()).addValue("id", (Object)validationStamp.id()));
        }
        catch (DuplicateKeyException ex) {
            throw new PredefinedValidationStampNameAlreadyDefinedException(validationStamp.getName());
        }
    }

    public Ack deletePredefinedValidationStamp(ID predefinedValidationStampId) {
        return Ack.one((int)this.getNamedParameterJdbcTemplate().update("DELETE FROM PREDEFINED_VALIDATION_STAMPS WHERE ID = :id", (SqlParameterSource)this.params("id", predefinedValidationStampId.get())));
    }

    public void setPredefinedValidationStampImage(ID predefinedValidationStampId, Document document) {
        this.getNamedParameterJdbcTemplate().update("UPDATE PREDEFINED_VALIDATION_STAMPS SET IMAGETYPE = :type, IMAGEBYTES = :content WHERE ID = :id", (SqlParameterSource)this.params("id", predefinedValidationStampId.getValue()).addValue("type", (Object)(Document.isValid((Document)document) ? document.getType() : null)).addValue("content", (Object)(Document.isValid((Document)document) ? document.getContent() : null)));
    }

    protected PredefinedValidationStamp toPredefinedValidationStamp(ResultSet rs) throws SQLException {
        return PredefinedValidationStamp.of((NameDescription)new NameDescription(rs.getString("name"), rs.getString("description"))).withId(this.id(rs)).withImage(StringUtils.isNotBlank((CharSequence)rs.getString("imagetype")));
    }
}

