/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.repository;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import javax.sql.DataSource;
import net.nemerosa.ontrack.common.Document;
import net.nemerosa.ontrack.model.Ack;
import net.nemerosa.ontrack.model.exceptions.PredefinedPromotionLevelNameAlreadyDefinedException;
import net.nemerosa.ontrack.model.structure.ID;
import net.nemerosa.ontrack.model.structure.NameDescription;
import net.nemerosa.ontrack.model.structure.PredefinedPromotionLevel;
import net.nemerosa.ontrack.model.structure.Reordering;
import net.nemerosa.ontrack.repository.PredefinedPromotionLevelRepository;
import net.nemerosa.ontrack.repository.support.AbstractJdbcRepository;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class PredefinedPromotionLevelJdbcRepository
extends AbstractJdbcRepository
implements PredefinedPromotionLevelRepository {
    @Autowired
    public PredefinedPromotionLevelJdbcRepository(DataSource dataSource) {
        super(dataSource);
    }

    public List<PredefinedPromotionLevel> getPredefinedPromotionLevels() {
        return this.getJdbcTemplate().query("SELECT * FROM PREDEFINED_PROMOTION_LEVELS ORDER BY ORDERNB", (rs, rowNum) -> this.toPredefinedPromotionLevel(rs));
    }

    public ID newPredefinedPromotionLevel(PredefinedPromotionLevel stamp) {
        try {
            Integer orderNbValue = (Integer)this.getFirstItem("SELECT MAX(ORDERNB) FROM PREDEFINED_PROMOTION_LEVELS", this.noParams(), Integer.class);
            int orderNb = orderNbValue != null ? orderNbValue + 1 : 0;
            return ID.of((int)this.dbCreate("INSERT INTO PREDEFINED_PROMOTION_LEVELS(NAME, ORDERNB, DESCRIPTION) VALUES (:name, :orderNb, :description)", this.params("name", stamp.getName()).addValue("description", (Object)stamp.getDescription()).addValue("orderNb", (Object)orderNb)));
        }
        catch (DuplicateKeyException ex) {
            throw new PredefinedPromotionLevelNameAlreadyDefinedException(stamp.getName());
        }
    }

    public PredefinedPromotionLevel getPredefinedPromotionLevel(ID id) {
        return (PredefinedPromotionLevel)this.getNamedParameterJdbcTemplate().queryForObject("SELECT * FROM PREDEFINED_PROMOTION_LEVELS WHERE ID = :id", (SqlParameterSource)this.params("id", id.get()), (rs, rowNum) -> this.toPredefinedPromotionLevel(rs));
    }

    public Optional<PredefinedPromotionLevel> findPredefinedPromotionLevelByName(String name) {
        return this.getOptional("SELECT * FROM PREDEFINED_PROMOTION_LEVELS WHERE NAME = :name", this.params("name", name), (rs, rowNum) -> this.toPredefinedPromotionLevel(rs));
    }

    public Document getPredefinedPromotionLevelImage(ID id) {
        return this.getOptional("SELECT IMAGETYPE, IMAGEBYTES FROM PREDEFINED_PROMOTION_LEVELS WHERE ID = :id", this.params("id", id.getValue()), (rs, rowNum) -> this.toDocument(rs)).orElse(Document.EMPTY);
    }

    public void savePredefinedPromotionLevel(PredefinedPromotionLevel validationStamp) {
        try {
            this.getNamedParameterJdbcTemplate().update("UPDATE PREDEFINED_PROMOTION_LEVELS SET NAME = :name, DESCRIPTION = :description WHERE ID = :id", (SqlParameterSource)this.params("name", validationStamp.getName()).addValue("description", (Object)validationStamp.getDescription()).addValue("id", (Object)validationStamp.id()));
        }
        catch (DuplicateKeyException ex) {
            throw new PredefinedPromotionLevelNameAlreadyDefinedException(validationStamp.getName());
        }
    }

    public Ack deletePredefinedPromotionLevel(ID predefinedPromotionLevelId) {
        return Ack.one((int)this.getNamedParameterJdbcTemplate().update("DELETE FROM PREDEFINED_PROMOTION_LEVELS WHERE ID = :id", (SqlParameterSource)this.params("id", predefinedPromotionLevelId.get())));
    }

    public void setPredefinedPromotionLevelImage(ID predefinedPromotionLevelId, Document document) {
        this.getNamedParameterJdbcTemplate().update("UPDATE PREDEFINED_PROMOTION_LEVELS SET IMAGETYPE = :type, IMAGEBYTES = :content WHERE ID = :id", (SqlParameterSource)this.params("id", predefinedPromotionLevelId.getValue()).addValue("type", (Object)(Document.isValid((Document)document) ? document.getType() : null)).addValue("content", (Object)(Document.isValid((Document)document) ? document.getContent() : null)));
    }

    public void reorderPredefinedPromotionLevels(Reordering reordering) {
        int order = 1;
        Iterator iterator = reordering.getIds().iterator();
        while (iterator.hasNext()) {
            int id = (Integer)iterator.next();
            this.getNamedParameterJdbcTemplate().update("UPDATE PREDEFINED_PROMOTION_LEVELS SET ORDERNB = :order WHERE ID = :id", (SqlParameterSource)this.params("id", id).addValue("order", (Object)order++));
        }
    }

    protected PredefinedPromotionLevel toPredefinedPromotionLevel(ResultSet rs) throws SQLException {
        return PredefinedPromotionLevel.of((NameDescription)new NameDescription(rs.getString("name"), rs.getString("description"))).withId(this.id(rs)).withImage(StringUtils.isNotBlank((CharSequence)rs.getString("imagetype")));
    }
}

