/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.repository;

import com.fasterxml.jackson.databind.JsonNode;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDateTime;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.sql.DataSource;
import net.nemerosa.ontrack.model.events.Event;
import net.nemerosa.ontrack.model.events.EventType;
import net.nemerosa.ontrack.model.structure.ID;
import net.nemerosa.ontrack.model.structure.ProjectEntity;
import net.nemerosa.ontrack.model.structure.ProjectEntityType;
import net.nemerosa.ontrack.model.structure.Signature;
import net.nemerosa.ontrack.model.support.NameValue;
import net.nemerosa.ontrack.repository.EventRepository;
import net.nemerosa.ontrack.repository.support.AbstractJdbcRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class EventJdbcRepository
extends AbstractJdbcRepository
implements EventRepository {
    @Autowired
    public EventJdbcRepository(DataSource dataSource) {
        super(dataSource);
    }

    public void post(Event event) {
        StringBuilder sql = new StringBuilder("INSERT INTO EVENTS(EVENT_VALUES, EVENT_TIME, EVENT_USER, EVENT_TYPE, REF");
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue("eventValues", (Object)this.writeJson(event.getValues()));
        params.addValue("eventTime", (Object)EventJdbcRepository.dateTimeForDB((LocalDateTime)event.getSignature().getTime()));
        params.addValue("eventUser", (Object)event.getSignature().getUser().getName());
        params.addValue("eventType", (Object)event.getEventType().getId());
        params.addValue("ref", event.getRef() != null ? event.getRef().name() : null);
        for (ProjectEntityType projectEntityType : event.getEntities().keySet()) {
            sql.append(", ").append(projectEntityType.name());
        }
        sql.append(") VALUES (:eventValues, :eventTime, :eventUser, :eventType, :ref");
        for (Map.Entry entry : event.getEntities().entrySet()) {
            ProjectEntityType type = (ProjectEntityType)entry.getKey();
            ProjectEntity entity = (ProjectEntity)entry.getValue();
            String typeEntry = type.name().toLowerCase();
            sql.append(", :").append(typeEntry);
            params.addValue(typeEntry, (Object)entity.id());
        }
        sql.append(")");
        this.getNamedParameterJdbcTemplate().update(sql.toString(), (SqlParameterSource)params);
    }

    public List<Event> query(List<Integer> allowedProjects, int offset, int count, BiFunction<ProjectEntityType, ID, ProjectEntity> entityLoader, Function<String, EventType> eventTypeLoader) {
        return this.getNamedParameterJdbcTemplate().query("SELECT * FROM EVENTS WHERE PROJECT IS NULL OR PROJECT IN (:projects) ORDER BY ID DESC LIMIT :count OFFSET :offset", (SqlParameterSource)this.params("projects", allowedProjects).addValue("count", (Object)count).addValue("offset", (Object)offset), (rs, num) -> this.toEvent(rs, entityLoader, eventTypeLoader));
    }

    public List<Event> query(ProjectEntityType entityType, ID entityId, int offset, int count, BiFunction<ProjectEntityType, ID, ProjectEntity> entityLoader, Function<String, EventType> eventTypeLoader) {
        return this.getNamedParameterJdbcTemplate().query(String.format("SELECT * FROM EVENTS WHERE %s = :entityId", entityType.name()) + " ORDER BY ID DESC LIMIT :count OFFSET :offset", (SqlParameterSource)this.params("entityId", entityId.get()).addValue("count", (Object)count).addValue("offset", (Object)offset), (rs, num) -> this.toEvent(rs, entityLoader, eventTypeLoader));
    }

    public List<Event> query(EventType eventType, ProjectEntityType entityType, ID entityId, int offset, int count, BiFunction<ProjectEntityType, ID, ProjectEntity> entityLoader, Function<String, EventType> eventTypeLoader) {
        return this.getNamedParameterJdbcTemplate().query(String.format("SELECT * FROM EVENTS WHERE %s = :entityId", entityType.name()) + " AND EVENT_TYPE = :eventType ORDER BY ID DESC LIMIT :count OFFSET :offset", (SqlParameterSource)this.params("entityId", entityId.get()).addValue("eventType", (Object)eventType.getId()).addValue("count", (Object)count).addValue("offset", (Object)offset), (rs, num) -> this.toEvent(rs, entityLoader, eventTypeLoader));
    }

    public Optional<Signature> getLastEventSignature(ProjectEntityType entityType, ID entityId, EventType eventType) {
        return this.getOptional(String.format("SELECT * FROM EVENTS WHERE %s = :entityId AND EVENT_TYPE = :eventType ORDER BY ID DESC LIMIT 1", entityType.name()), this.params("entityId", entityId.get()).addValue("eventType", (Object)eventType.getId()), (rs, num) -> this.readSignature(rs, "event_time", "event_user"));
    }

    public Optional<Event> getLastEvent(ProjectEntityType entityType, ID entityId, EventType eventType, BiFunction<ProjectEntityType, ID, ProjectEntity> entityLoader, Function<String, EventType> eventTypeLoader) {
        return this.getOptional(String.format("SELECT * FROM EVENTS WHERE %s = :entityId AND EVENT_TYPE = :eventType ORDER BY ID DESC LIMIT 1", entityType.name()), this.params("entityId", entityId.get()).addValue("eventType", (Object)eventType.getId()), (rs, num) -> this.toEvent(rs, entityLoader, eventTypeLoader));
    }

    private Event toEvent(ResultSet rs, BiFunction<ProjectEntityType, ID, ProjectEntity> entityLoader, Function<String, EventType> eventTypeLoader) throws SQLException {
        String eventTypeName = rs.getString("event_type");
        Signature signature = this.readSignature(rs, "event_time", "event_user");
        LinkedHashMap<ProjectEntityType, ProjectEntity> entities = new LinkedHashMap<ProjectEntityType, ProjectEntity>();
        for (ProjectEntityType type : ProjectEntityType.values()) {
            int entityId = rs.getInt(type.name());
            if (rs.wasNull()) continue;
            ProjectEntity entity = entityLoader.apply(type, ID.of((int)entityId));
            entities.put(type, entity);
        }
        ProjectEntityType refEntity = (ProjectEntityType)this.getEnum(ProjectEntityType.class, rs, "ref");
        Map<String, NameValue> values = this.loadValues(rs);
        return new Event(eventTypeLoader.apply(eventTypeName), signature, entities, refEntity, values);
    }

    private Map<String, NameValue> loadValues(ResultSet rs) throws SQLException {
        LinkedHashMap<String, NameValue> map = new LinkedHashMap<String, NameValue>();
        JsonNode node = this.readJson(rs, "event_values");
        Iterator i = node.fields();
        while (i.hasNext()) {
            Map.Entry child = (Map.Entry)i.next();
            String key = (String)child.getKey();
            JsonNode nameValue = (JsonNode)child.getValue();
            map.put(key, new NameValue(nameValue.path("name").asText(), nameValue.path("value").asText()));
        }
        return map;
    }
}

