/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.repository;

import com.fasterxml.jackson.databind.JsonNode;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDateTime;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import net.nemerosa.ontrack.json.JsonUtils;
import net.nemerosa.ontrack.model.structure.ProjectEntity;
import net.nemerosa.ontrack.model.structure.Signature;
import net.nemerosa.ontrack.repository.support.AbstractJdbcRepository;
import net.nemerosa.ontrack.repository.support.store.EntityDataStore;
import net.nemerosa.ontrack.repository.support.store.EntityDataStoreFilter;
import net.nemerosa.ontrack.repository.support.store.EntityDataStoreRecord;
import net.nemerosa.ontrack.repository.support.store.EntityDataStoreRecordAudit;
import net.nemerosa.ontrack.repository.support.store.EntityDataStoreRecordAuditType;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class EntityDataStoreJdbcRepository
extends AbstractJdbcRepository
implements EntityDataStore {
    @Autowired
    public EntityDataStoreJdbcRepository(DataSource dataSource) {
        super(dataSource);
    }

    public EntityDataStoreRecord add(ProjectEntity entity, String category, String name, Signature signature, String groupName, JsonNode data) {
        int id = this.dbCreate(String.format("INSERT INTO ENTITY_DATA_STORE(%s, CATEGORY, NAME, GROUPID, JSON, CREATION, CREATOR) VALUES (:entityId, :category, :name, :groupId, :json, :creation, :creator)", entity.getProjectEntityType().name()), this.params("entityId", entity.id()).addValue("category", (Object)category).addValue("name", (Object)name).addValue("groupId", (Object)groupName).addValue("json", (Object)this.writeJson(data)).addValue("creation", (Object)EntityDataStoreJdbcRepository.dateTimeForDB((LocalDateTime)signature.getTime())).addValue("creator", (Object)signature.getUser().getName()));
        this.audit(EntityDataStoreRecordAuditType.CREATED, id, signature);
        return new EntityDataStoreRecord(id, entity, category, name, groupName, signature, data);
    }

    public EntityDataStoreRecord replaceOrAdd(ProjectEntity entity, String category, String name, Signature signature, String groupName, JsonNode data) {
        Integer id = (Integer)this.getFirstItem(String.format("SELECT ID FROM ENTITY_DATA_STORE WHERE %s = :entityId AND CATEGORY = :category AND NAME = :name ORDER BY ID DESC LIMIT 1", entity.getProjectEntityType().name()), this.params("entityId", entity.id()).addValue("category", (Object)category).addValue("name", (Object)name), Integer.class);
        if (id != null) {
            this.getNamedParameterJdbcTemplate().update("UPDATE ENTITY_DATA_STORE SET CREATION = :creation, CREATOR = :creator, JSON = :json, GROUPID = :groupId WHERE ID = :id", (SqlParameterSource)this.params("id", id).addValue("groupId", (Object)groupName).addValue("json", (Object)this.writeJson(data)).addValue("creation", (Object)EntityDataStoreJdbcRepository.dateTimeForDB((LocalDateTime)signature.getTime())).addValue("creator", (Object)signature.getUser().getName()));
            this.audit(EntityDataStoreRecordAuditType.UPDATED, id, signature);
            return new EntityDataStoreRecord(id.intValue(), entity, category, name, groupName, signature, data);
        }
        return this.add(entity, category, name, signature, groupName, data);
    }

    public List<EntityDataStoreRecordAudit> getRecordAudit(int id) {
        return this.getNamedParameterJdbcTemplate().query("SELECT * FROM ENTITY_DATA_STORE_AUDIT WHERE RECORD_ID = :recordId ORDER BY ID DESC", (SqlParameterSource)this.params("recordId", id), (rs, rowNum) -> new EntityDataStoreRecordAudit(EntityDataStoreRecordAuditType.valueOf((String)rs.getString("AUDIT_TYPE")), this.readSignature(rs, "TIMESTAMP", "USER")));
    }

    public void deleteByName(ProjectEntity entity, String category, String name) {
        this.getNamedParameterJdbcTemplate().update(String.format("DELETE FROM ENTITY_DATA_STORE WHERE %s = :entityId AND CATEGORY = :category AND NAME = :name", entity.getProjectEntityType().name()), (SqlParameterSource)this.params("entityId", entity.id()).addValue("category", (Object)category).addValue("name", (Object)name));
    }

    public void deleteByGroup(ProjectEntity entity, String category, String groupName) {
        this.getNamedParameterJdbcTemplate().update(String.format("DELETE FROM ENTITY_DATA_STORE WHERE %s = :entityId AND CATEGORY = :category AND GROUPID = :groupId", entity.getProjectEntityType().name()), (SqlParameterSource)this.params("entityId", entity.id()).addValue("category", (Object)category).addValue("groupId", (Object)groupName));
    }

    public void deleteByCategoryBefore(String category, LocalDateTime beforeTime) {
        this.getNamedParameterJdbcTemplate().update("DELETE FROM ENTITY_DATA_STORE WHERE CATEGORY = :category AND CREATION <= :beforeTime", (SqlParameterSource)this.params("category", category).addValue("beforeTime", (Object)EntityDataStoreJdbcRepository.dateTimeForDB((LocalDateTime)beforeTime)));
    }

    public Optional<EntityDataStoreRecord> findLastByCategoryAndName(ProjectEntity entity, String category, String name, LocalDateTime beforeTime) {
        String sql = String.format("SELECT * FROM ENTITY_DATA_STORE WHERE %s = :entityId AND CATEGORY = :category AND NAME = :name ", entity.getProjectEntityType().name());
        MapSqlParameterSource params = this.params("entityId", entity.id()).addValue("category", (Object)category).addValue("name", (Object)name);
        if (beforeTime != null) {
            sql = sql + "AND CREATION <= :beforeTime ";
            params = params.addValue("beforeTime", (Object)EntityDataStoreJdbcRepository.dateTimeForDB((LocalDateTime)beforeTime));
        }
        sql = sql + "ORDER BY CREATION DESC, ID DESC LIMIT 1";
        return this.getOptional(sql, params, (rs, rowNum) -> this.toEntityDataStoreRecord(entity, rs));
    }

    public Optional<EntityDataStoreRecord> findLastByCategoryAndGroupAndName(ProjectEntity entity, String category, String groupName, String name) {
        return this.getLastByName(this.getNamedParameterJdbcTemplate().query(String.format("SELECT * FROM ENTITY_DATA_STORE WHERE %s = :entityId AND CATEGORY = :category AND GROUPID = :groupId AND NAME = :name", entity.getProjectEntityType().name()), (SqlParameterSource)this.params("entityId", entity.id()).addValue("category", (Object)category).addValue("groupId", (Object)groupName).addValue("name", (Object)name), (rs, rowNum) -> this.toEntityDataStoreRecord(entity, rs))).stream().findFirst();
    }

    public List<EntityDataStoreRecord> findLastRecordsByNameInCategory(ProjectEntity entity, String category) {
        return this.getLastByName(this.getNamedParameterJdbcTemplate().query(String.format("SELECT * FROM ENTITY_DATA_STORE WHERE %s = :entityId AND CATEGORY = :category ORDER BY CREATION DESC, ID DESC", entity.getProjectEntityType().name()), (SqlParameterSource)this.params("entityId", entity.id()).addValue("category", (Object)category), (rs, rowNum) -> this.toEntityDataStoreRecord(entity, rs)));
    }

    private List<EntityDataStoreRecord> getLastByName(List<EntityDataStoreRecord> entries) {
        return entries.stream().collect(Collectors.groupingBy(EntityDataStoreRecord::getName)).values().stream().map(list -> list.stream().sorted(Comparator.naturalOrder()).findFirst()).filter(Optional::isPresent).map(Optional::get).sorted(Comparator.naturalOrder()).collect(Collectors.toList());
    }

    private EntityDataStoreRecord toEntityDataStoreRecord(ProjectEntity entity, ResultSet rs) throws SQLException {
        return new EntityDataStoreRecord(rs.getInt("ID"), entity, rs.getString("CATEGORY"), rs.getString("NAME"), rs.getString("GROUPID"), this.readSignature(rs), this.readJson(rs, "JSON"));
    }

    public EntityDataStoreRecord addObject(ProjectEntity entity, String category, String name, Signature signature, String groupName, Object data) {
        return this.add(entity, category, name, signature, groupName, JsonUtils.format((Object)data));
    }

    public EntityDataStoreRecord replaceOrAddObject(ProjectEntity entity, String category, String name, Signature signature, String groupName, Object data) {
        return this.replaceOrAdd(entity, category, name, signature, groupName, JsonUtils.format((Object)data));
    }

    public Optional<EntityDataStoreRecord> getById(ProjectEntity entity, int id) {
        return this.getOptional(String.format("SELECT * FROM ENTITY_DATA_STORE WHERE %s = :entityId AND ID = :id", entity.getProjectEntityType().name()), this.params("id", id).addValue("entityId", (Object)entity.id()), (rs, rowNum) -> this.toEntityDataStoreRecord(entity, rs));
    }

    public List<EntityDataStoreRecord> getByCategoryAndName(ProjectEntity entity, String category, String name, int offset, int page) {
        return this.getNamedParameterJdbcTemplate().query(String.format("SELECT * FROM ENTITY_DATA_STORE WHERE %s = :entityId AND CATEGORY = :category AND NAME = :name ORDER BY CREATION DESC, ID DESC LIMIT :page OFFSET :offset", entity.getProjectEntityType().name()), (SqlParameterSource)this.params("entityId", entity.id()).addValue("category", (Object)category).addValue("name", (Object)name).addValue("offset", (Object)offset).addValue("page", (Object)page), (rs, rowNum) -> this.toEntityDataStoreRecord(entity, rs));
    }

    public List<EntityDataStoreRecord> getByCategory(ProjectEntity entity, String category, int offset, int page) {
        return this.getNamedParameterJdbcTemplate().query(String.format("SELECT * FROM ENTITY_DATA_STORE WHERE %s = :entityId AND CATEGORY = :category ORDER BY CREATION DESC, ID DESC LIMIT :page OFFSET :offset", entity.getProjectEntityType().name()), (SqlParameterSource)this.params("entityId", entity.id()).addValue("category", (Object)category).addValue("offset", (Object)offset).addValue("page", (Object)page), (rs, rowNum) -> this.toEntityDataStoreRecord(entity, rs));
    }

    public int getCountByCategoryAndName(ProjectEntity entity, String category, String name) {
        return (Integer)this.getNamedParameterJdbcTemplate().queryForObject(String.format("SELECT COUNT(*) FROM ENTITY_DATA_STORE WHERE %s = :entityId AND CATEGORY = :category AND NAME = :name ", entity.getProjectEntityType().name()), (SqlParameterSource)this.params("entityId", entity.id()).addValue("category", (Object)category).addValue("name", (Object)name), Integer.class);
    }

    public int getCountByCategory(ProjectEntity entity, String category) {
        return (Integer)this.getNamedParameterJdbcTemplate().queryForObject(String.format("SELECT COUNT(*) FROM ENTITY_DATA_STORE WHERE %s = :entityId AND CATEGORY = :category ", entity.getProjectEntityType().name()), (SqlParameterSource)this.params("entityId", entity.id()).addValue("category", (Object)category), Integer.class);
    }

    public void deleteAll() {
        this.getJdbcTemplate().update("DELETE FROM ENTITY_DATA_STORE");
    }

    public List<EntityDataStoreRecord> getByFilter(EntityDataStoreFilter entityDataStoreFilter) {
        if (entityDataStoreFilter.getEntity() == null) {
            throw new IllegalArgumentException("The filter `entity` parameter is required.");
        }
        StringBuilder critera = new StringBuilder();
        MapSqlParameterSource params = new MapSqlParameterSource();
        this.buildCriteria(entityDataStoreFilter, critera, params);
        return this.getNamedParameterJdbcTemplate().query(String.format("SELECT * FROM ENTITY_DATA_STORE WHERE 1 = 1  %s ORDER BY CREATION DESC, ID DESC LIMIT :page OFFSET :offset", critera), (SqlParameterSource)params.addValue("offset", (Object)entityDataStoreFilter.getOffset()).addValue("page", (Object)entityDataStoreFilter.getCount()), (rs, rowNum) -> this.toEntityDataStoreRecord(entityDataStoreFilter.getEntity(), rs));
    }

    public int getCountByFilter(EntityDataStoreFilter entityDataStoreFilter) {
        StringBuilder critera = new StringBuilder();
        MapSqlParameterSource params = new MapSqlParameterSource();
        this.buildCriteria(entityDataStoreFilter, critera, params);
        return (Integer)this.getNamedParameterJdbcTemplate().queryForObject(String.format("SELECT COUNT(*) FROM ENTITY_DATA_STORE WHERE 1 = 1  %s LIMIT :page OFFSET :offset", critera), (SqlParameterSource)params.addValue("offset", (Object)entityDataStoreFilter.getOffset()).addValue("page", (Object)entityDataStoreFilter.getCount()), Integer.class);
    }

    public int deleteByFilter(EntityDataStoreFilter entityDataStoreFilter) {
        StringBuilder critera = new StringBuilder();
        MapSqlParameterSource params = new MapSqlParameterSource();
        this.buildCriteria(entityDataStoreFilter, critera, params);
        return this.getNamedParameterJdbcTemplate().update(String.format("DELETE FROM ENTITY_DATA_STORE WHERE 1 = 1 %s ", critera), (SqlParameterSource)params);
    }

    private void buildCriteria(EntityDataStoreFilter filter, StringBuilder criteria, MapSqlParameterSource params) {
        if (filter.getEntity() != null) {
            criteria.append(String.format(" AND %s = :entityId", filter.getEntity().getProjectEntityType().name()));
            params.addValue("entityId", (Object)filter.getEntity().id());
        }
        if (StringUtils.isNotBlank((CharSequence)filter.getCategory())) {
            criteria.append(" AND CATEGORY = :category");
            params.addValue("category", (Object)filter.getCategory());
        }
        if (StringUtils.isNotBlank((CharSequence)filter.getName())) {
            criteria.append(" AND NAME = :name");
            params.addValue("name", (Object)filter.getName());
        }
        if (StringUtils.isNotBlank((CharSequence)filter.getGroup())) {
            criteria.append(" AND GROUPID = :group");
            params.addValue("group", (Object)filter.getGroup());
        }
        if (filter.getBeforeTime() != null) {
            criteria.append(" AND CREATION <= :beforeTime");
            params.addValue("beforeTime", (Object)EntityDataStoreJdbcRepository.dateTimeForDB((LocalDateTime)filter.getBeforeTime()));
        }
    }

    private void audit(EntityDataStoreRecordAuditType type, int recordId, Signature signature) {
        this.getNamedParameterJdbcTemplate().update("INSERT INTO ENTITY_DATA_STORE_AUDIT(RECORD_ID, AUDIT_TYPE, TIMESTAMP, USER) VALUES (:recordId, :auditType, :timestamp, :user)", (SqlParameterSource)this.params("recordId", recordId).addValue("auditType", (Object)type.name()).addValue("timestamp", (Object)EntityDataStoreJdbcRepository.dateTimeForDB((LocalDateTime)signature.getTime())).addValue("user", (Object)signature.getUser().getName()));
    }
}

