/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.repository;

import java.util.Optional;
import javax.sql.DataSource;
import net.nemerosa.ontrack.model.structure.ProjectEntity;
import net.nemerosa.ontrack.repository.EntityDataRepository;
import net.nemerosa.ontrack.repository.support.AbstractJdbcRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class EntityDataJdbcRepository
extends AbstractJdbcRepository
implements EntityDataRepository {
    @Autowired
    public EntityDataJdbcRepository(DataSource dataSource) {
        super(dataSource);
    }

    public void store(ProjectEntity entity, String key, String value) {
        Optional existingId = this.getOptional(String.format("SELECT ID FROM ENTITY_DATA WHERE %s = :entityId AND NAME = :name", entity.getProjectEntityType().name()), this.params("entityId", entity.id()).addValue("name", (Object)key), Integer.class);
        if (existingId.isPresent()) {
            this.getNamedParameterJdbcTemplate().update("UPDATE ENTITY_DATA SET VALUE = :value WHERE ID = :id", (SqlParameterSource)this.params("id", existingId.get()).addValue("value", (Object)value));
        } else {
            this.getNamedParameterJdbcTemplate().update(String.format("INSERT INTO ENTITY_DATA(%s, NAME, VALUE) VALUES (:entityId, :name, :value)", entity.getProjectEntityType().name()), (SqlParameterSource)this.params("entityId", entity.id()).addValue("name", (Object)key).addValue("value", (Object)value));
        }
    }

    public Optional<String> retrieve(ProjectEntity entity, String key) {
        return this.getOptional(String.format("SELECT VALUE FROM ENTITY_DATA WHERE %s = :entityId AND NAME = :name", entity.getProjectEntityType().name()), this.params("entityId", entity.id()).addValue("name", (Object)key), String.class);
    }

    public void delete(ProjectEntity entity, String key) {
        this.getNamedParameterJdbcTemplate().update(String.format("DELETE FROM ENTITY_DATA WHERE %s = :entityId AND NAME = :name", entity.getProjectEntityType().name()), (SqlParameterSource)this.params("entityId", entity.id()).addValue("name", (Object)key));
    }
}

